package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 施工派工工单
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WorkOrderDto", description="施工派工工单")
public class WorkOrderDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "派工单编号")
    private String workOrderNum;

    @ApiModelProperty(value = "制单人")
    private String preparer;

    @ApiModelProperty(value = "制单日期")
    private Date issueDate;

    @ApiModelProperty(value = "计划开工日期")
    private Date plannedStartDate;

    @ApiModelProperty(value = "计划完工日期")
    private Date plannedEndDate;

    @ApiModelProperty(value = "区域公司id")
    private Long regionCompanyId;

    @ApiModelProperty(value = "区域公司名称")
    private String regionCompanyName;

    @ApiModelProperty(value = "区域公司orgcode")
    private String regionCode;

    @ApiModelProperty(value = "工程负责人")
    private String projectRegionManager;

    @ApiModelProperty(value = "工程负责人电话")
    private String projectRegionManagerPhone;

    @ApiModelProperty(value = "施工负责人")
    private String constructionRegionManager;

    @ApiModelProperty(value = "施工负责人电话")
    private String constructionRegionManagerPhone;

    @ApiModelProperty(value = "派工单状态")
    private String workOrderStatus;

    List<PeasantHousehold> peasantHouseholdId;
}
