package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 发货单
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value="hygf_preparation_money",autoResultMap = true)
public class PreparationMoney extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     *   发货单号
     */
	@TableField("odd_numbers")
    private String oddNumbers;



    /**
     *  下单人
     */
	@TableField("order_user")
    private String orderUser;

    /**
     * 下单时间
     */
	@TableField("order_time")
    private Date orderTime;


    /**
     * 经销商单位名称
     */
    @TableField("amos_unit_name")
    private String amosUnitName;

    /**
     * 经销商单位id
     */
    @TableField("amos_unit_id")
    private Long amosUnitId;
    /**
     * 经销商orgcode
     */
    @TableField("amos_unit_org_code")
    private String amosUnitOrgCode;


    /**
     * 所属区域公司id
     */
    @TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;

    /**
     * 所属区域公司名称
     */
    @TableField("regional_companies_name")
    private String regionalCompaniesName;

    /**
     * 所属区域公司code
     */
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;

    /**
     * 发货人
     */
    @TableField("shipper")
    private String shipper;

    /**
     * 预估重量
     */
    @TableField("estimated_weight")
    private Double estimatedWeight;

    /**
     * 备注
     */
    @TableField("notes")
    private String notes;

    /**
     * 发货状态0待发货1已发货成2已作废
     */
    @TableField("delivery_state")
    private String deliveryState;

    /**
     * 到货货状态 待收货1已收货成2已作废
     */
    @TableField("arrival_state")
    private String arrivalState;
    /**
     * 发货时间
     */
    @TableField("delivery_time")
    private Date deliveryTime;
    /**
     * 到货时间
     */
    @TableField("arrival_time")
    private Date arrivalTime;

    @TableField("consignee")
    private String consignee;	//收货人

    @TableField("phone")
    private String phone;	//收货人电话

    @TableField("consignee_region")
    private String consigneeRegion;	//收货区域

    @TableField(value = "consignee_region_code",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> consigneeRegionCode;	//收货区域code

    @TableField("address")
    private String address;	//收货详细地址

    @TableField(value = "delivery_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> deliveryFile; //发货单

    @TableField(value = "arrival_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> arrivalFile;  //收货单

    @TableField(exist = false)
    private List<DocumentStation> peasantHouseholdId;  //发货单

    @TableField(exist = false)
    private List<PreparationMoneyLog> preparationMoneyLog;  //发货单流水



}
