package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 施工派工工单
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_work_order")
public class WorkOrder extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 派工单编号
     */
	@TableField("work_order_num")
    private String workOrderNum;

    /**
     * 制单人
     */
	@TableField("preparer")
    private String preparer;

    /**
     * 制单日期
     */
	@TableField("issue_date")
    private Date issueDate;

    /**
     * 计划开工日期
     */
	@TableField("planned_start_date")
    private Date plannedStartDate;

    /**
     * 计划完工日期
     */
	@TableField("planned_end_date")
    private Date plannedEndDate;

    /**
     * 区域公司id
     */
	@TableField("region_company_id")
    private Long regionCompanyId;

    /**
     * 区域公司名称
     */
	@TableField("region_company_name")
    private String regionCompanyName;

    /**
     * 区域公司orgcode
     */
	@TableField("region__code")
    private String regionCode;

    /**
     * 工程负责人
     */
	@TableField("project_region_manager")
    private String projectRegionManager;

    /**
     * 工程负责人电话
     */
	@TableField("project_region_manager_phone")
    private String projectRegionManagerPhone;

    /**
     * 施工负责人
     */
	@TableField("construction_region_manager")
    private String constructionRegionManager;

    /**
     * 施工负责人电话
     */
	@TableField("construction_region_manager_phone")
    private String constructionRegionManagerPhone;

    /**
     * 派工单状态
     */
	@TableField("work_order_status")
    private String workOrderStatus;


    @TableField(exist = false)
    List<PeasantHousehold> peasantHouseholdId;


}
