package com.yeejoin.amos.boot.module.hygf.api.util;


import com.yeejoin.amos.boot.module.hygf.api.util.Constants;

import org.springframework.http.HttpStatus;

public class CommonResponseUtil
{
	public static CommonResponse success()
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_SUCCESS);
		response.setStatus(HttpStatus.OK.value());
		return response;
	}

	public static CommonResponse success(Object obj)
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_SUCCESS);
		response.setStatus(HttpStatus.OK.value());
		response.setDataList(obj);
		return response;
	}

	public static CommonResponse success(Object obj, String message)
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_SUCCESS);
		response.setStatus(HttpStatus.OK.value());
		response.setDataList(obj);
		response.setMessage(message);
		return response;
	}

	public static CommonResponse failure()
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_FAILURE);
		response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return response;
	}

	public static CommonResponse failure(String message)
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_FAILURE);
		response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		response.setMessage(message);
		return response;
	}

	public static CommonResponse failure(Object obj, String message)
	{
		CommonResponse response = new CommonResponse();
		response.setResult(Constants.RESULT_FAILURE);
		response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		response.setDataList(obj);
		response.setMessage(message);
		return response;
	}
}
