package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpStationPowerHistoryServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpStationPowerHistoryDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘电站功率表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘电站功率表Api")
@RequestMapping(value = "/td-hygf-jp-station-power-history")
public class TdHygfJpStationPowerHistoryController extends BaseController {

    @Autowired
    TdHygfJpStationPowerHistoryServiceImpl tdHygfJpStationPowerHistoryServiceImpl;

    /**
     * 新增户用光伏监盘电站功率表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘电站功率表", notes = "新增户用光伏监盘电站功率表")
	public ResponseModel<TdHygfJpStationPowerHistoryDto> save(@RequestBody TdHygfJpStationPowerHistoryDto model) {
	    model = tdHygfJpStationPowerHistoryServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘电站功率表", notes = "根据sequenceNbr更新户用光伏监盘电站功率表")
	public ResponseModel<TdHygfJpStationPowerHistoryDto> updateBySequenceNbrTdHygfJpStationPowerHistory(@RequestBody TdHygfJpStationPowerHistoryDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(tdHygfJpStationPowerHistoryServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘电站功率表", notes = "根据sequenceNbr删除户用光伏监盘电站功率表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(tdHygfJpStationPowerHistoryServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏监盘电站功率表",  notes = "根据sequenceNbr查询单个户用光伏监盘电站功率表")
	public ResponseModel<TdHygfJpStationPowerHistoryDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(tdHygfJpStationPowerHistoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘电站功率表分页查询",  notes = "户用光伏监盘电站功率表分页查询")
	public ResponseModel<Page<TdHygfJpStationPowerHistoryDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<TdHygfJpStationPowerHistoryDto> page = new Page<TdHygfJpStationPowerHistoryDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(tdHygfJpStationPowerHistoryServiceImpl.queryForTdHygfJpStationPowerHistoryPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘电站功率表列表全部数据查询",   notes = "户用光伏监盘电站功率表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TdHygfJpStationPowerHistoryDto>> selectForList() {
	    return ResponseHelper.buildResponse(tdHygfJpStationPowerHistoryServiceImpl.queryForTdHygfJpStationPowerHistoryList());
	}
}
