package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.entity.WorkOrder;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.WorkOrderServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 施工派工工单
 *
 * @author system_generator
 * @date 2024-01-02
 */
@RestController
@Api(tags = "施工派工工单Api")
@RequestMapping(value = "/work-order")
public class WorkOrderController extends BaseController {

    @Autowired
    WorkOrderServiceImpl workOrderServiceImpl;

    /**
     * 新增施工派工工单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工派工工单", notes = "新增施工派工工单")
	public ResponseModel<WorkOrder> save(@RequestBody WorkOrder model) {
	    model = workOrderServiceImpl.saveWorkOrder(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工派工工单", notes = "根据sequenceNbr更新施工派工工单")
	public ResponseModel<WorkOrderDto> updateBySequenceNbrWorkOrder(@RequestBody WorkOrderDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(workOrderServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工派工工单", notes = "根据sequenceNbr删除施工派工工单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(workOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工派工工单",  notes = "根据sequenceNbr查询单个施工派工工单")
	public ResponseModel<WorkOrderDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(workOrderServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工派工工单分页查询",  notes = "施工派工工单分页查询")
	public ResponseModel<Page<WorkOrderDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<WorkOrderDto> page = new Page<WorkOrderDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(workOrderServiceImpl.queryForWorkOrderPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工派工工单列表全部数据查询",   notes = "施工派工工单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WorkOrderDto>> selectForList() {
	    return ResponseHelper.buildResponse(workOrderServiceImpl.queryForWorkOrderList());
	}
}
