package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.yeejoin.amos.boot.module.hygf.api.Enum.CodeEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.WorkOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.RegionalCompanies;
import com.yeejoin.amos.boot.module.hygf.api.entity.WorkOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.RegionalCompaniesMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.WorkOrderMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IWorkOrderService;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderDto;
import com.yeejoin.amos.boot.module.hygf.api.util.NumberUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 施工派工工单服务实现类
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Service
public class WorkOrderServiceImpl extends BaseService<WorkOrderDto,WorkOrder,WorkOrderMapper> implements IWorkOrderService {

    @Autowired
    RegionalCompaniesMapper regionalCompaniesMapper;

    @Autowired
    WorkOrderMapper workOrderMapper;
    /**
     * 分页查询
     */
    public Page<WorkOrderDto> queryForWorkOrderPage(Page<WorkOrderDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<WorkOrderDto> queryForWorkOrderList()   {
        return this.queryForList("" , false);
    }





    public WorkOrder saveWorkOrder (WorkOrder model) {

        //保存派工单
        RegionalCompanies regionalCompanies= regionalCompaniesMapper.selectRegionName(model.getRegionCompanyId());
        String code=  NumberUtil.getCode(CodeEnum.派工单.getCode(),regionalCompanies.getCompanyCode(),regionalCompanies.getRegionalAddress());
        model.setWorkOrderNum(code);
        model.setRegionCompanyName(regionalCompanies.getRegionalCompaniesName());
        model.setRegionCode(regionalCompanies.getRegionalCompaniesCode());
        model.setWorkOrderStatus(WorkOrderEnum.待施工.getCode());
        workOrderMapper.insert(model);


        //保存派工单 电站信息
        List<PeasantHousehold> peasantHouseholdId=model.getPeasantHouseholdId();




        return model;
    }




}