package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


@FeignClient(name = "${mcb.warning.name:MCB-SERVER}", path = "warning", configuration = {FeignConfiguration.class})
public interface McbWarningFeign {

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/task/getQrCodeCount")
    FeignClientResult<Map<String, Object>> getQrCodeCount(@RequestParam(required = false, value = "parentCode") String parentCode,
                                                          @RequestParam(value = "warningObjectType") String warningObjectType);

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/task/getWarningInfoCountByObjectId")
    FeignClientResult<Integer> getWarningInfoCountByObjectId(@RequestParam(value = "code") String code);

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/task/getWarningInfoByTraceId")
    FeignClientResult<String> getWarningInfoByTraceId(@RequestParam(value = "traceId") String traceId);

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @PostMapping("/task/updateRawDataByTraceId")
    FeignClientResult<Boolean> updateRawDataByTraceId(@RequestParam(value = "traceId") String traceId, @RequestParam(value = "rawData") String rawData);

}
