package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.BizRecordCount;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.IdxUjerDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.feign.IdxFeignService;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.InspectionService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.model.Page;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

@RestController
@RequestMapping("/Inspection")
@Api(value = "监察处置分析")
public class InspectionController {

	@Autowired
	InspectionService inspectionService;

	@Autowired
	IdxFeignService idxFeignService;

	/**
	 * 双重预防
	 *
	 * @param dimensionTableId
	 * @param selectValue
	 * @param bizType
	 * @param current
	 * @param size
	 * @return
	 */
	@GetMapping("/bizDetailList")
	@ApiOperation(value = "检察任务填报详情")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<IPage<IdxUjerDto>> bizDetailList(@RequestParam String dimensionTableId,
			@RequestParam String selectValue, @RequestParam(required = false) String bizType, @RequestParam int current,
			@RequestParam int size) {
		IPage<IdxUjerDto> page = inspectionService.bizDetailList(dimensionTableId, selectValue, bizType, current, size);
		return ResponseHelper.buildResponse(page);
	}

	/**
	 * 生产、使用环节
	 *
	 * @param bizRecordCountList
	 * @return
	 */
	@PostMapping("/safetySupervision")
	@ApiOperation(value = "安全监察统计")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<List<Map<String, Object>>> safetySupervisionList(
			@RequestBody List<BizRecordCount> bizRecordCountList) {
		return ResponseHelper.buildResponse(inspectionService.bizRecordCountByField(bizRecordCountList));
	}

	/**
	 * 生产、使用环节
	 *
	 * @param bizRecordCount
	 * @return
	 */
	@PostMapping("/safetySupervisionForMap")
	@ApiOperation(value = "安全监察统计")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<Map<String, Object>> safetySupervisionForMap(@RequestBody BizRecordCount bizRecordCount) {
		return ResponseHelper.buildResponse(inspectionService.bizRecordCountByField(bizRecordCount));
	}

	/**
	 * 生成安全监察指令书编号
	 *
	 * @param bizTable
	 * @return
	 */
	@GetMapping("/getSafetySupervisionCode")
	@ApiOperation(value = "生成安全监察指令书编号")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<JSONObject> getSafetySupervisionCode(@RequestParam String bizTable,@RequestParam String taskId) {
		return ResponseHelper.buildResponse(inspectionService.getSafetySupervisionCode(bizTable,taskId));
	}

	/**
	 * 获取所有安全监察指令书编号
	 *
	 * @param bizTable
	 * @return
	 */
	@GetMapping("/getSafetySupervisionCodeMap")
	@ApiOperation(value = "获取所有安全监察指令书编号")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<JSONObject> getSafetySupervisionCodeMap(@RequestParam String bizTable,
			@RequestParam String mapKey, @RequestParam String mapValue) {
		return ResponseHelper.buildResponse(inspectionService.getSafetySupervisionCodeMap(bizTable, mapKey, mapValue));
	}

	/**
	 * 查询行政复议机构和行政诉讼机构
	 *
	 * @return
	 */
	@GetMapping("/getSafetySupervisionInfo")
	@ApiOperation(value = "查询行政复议机构和行政诉讼机构")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<JSONObject> getSafetySupervisionInfo() {
		return ResponseHelper.buildResponse(inspectionService.getSafetySupervisionInfo());
	}

	@GetMapping("/contacts")
	@ApiOperation(value = "通讯录")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<Page<AgencyUserModel>> contacts(@RequestParam(required = false) String realName,
			@RequestParam(required = false) String mobile, @RequestParam(required = false) String dimensionTableId,
			@RequestParam(required = false) String selectValue, @RequestParam int current, @RequestParam int size) {
//        List<String> ids = new ArrayList<>();
//        if (StringUtils.hasText(selectValue)) {
//            Collection<CompanyModel> a  = Privilege.companyClient.querySubAgencyTree(Long.valueOf(selectValue)).getResult();
//            ids = recursion(a,ids);
//        }
		FeignClientResult<CompanyModel> company = Privilege.companyClient.seleteOne(Long.valueOf(selectValue));
		FeignClientResult<Page<AgencyUserModel>> result = new FeignClientResult<Page<AgencyUserModel>>();
		if (company.getResult() != null) {
			result = Privilege.agencyUserClient.queryForPageByCompany(company.getResult().getOrgCode(), "headquarter,prefecture-level,county",
					mobile, realName, current, size);
		}
		return ResponseHelper.buildResponse(result.getResult());
	}

	public List recursion(Collection feign, List ids) {
		if (feign == null) {
			return ids;
		}
		Iterator iter = feign.iterator();
		while (iter.hasNext()) {
			String json = JSON.toJSONString(iter.next());
			CompanyModel companyModel = JSON.parseObject(json, CompanyModel.class);
			if (!companyModel.getLevel().equals("company")) {
				ids.add(String.valueOf(companyModel.getSequenceNbr()));
			}
			recursion(companyModel.getChildren(), ids);
		}
		return ids;
	}

	@GetMapping("/getMapByRegion/{regionSeq}")
	@ApiOperation(value = "获取下级行政区划下的所有数据")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	public ResponseModel<com.baomidou.mybatisplus.extension.plugins.pagination.Page> getMapByRegion(
			@PathVariable(value = "regionSeq") Long regionSeq, @RequestParam(value = "tableId") String tableId,
			@RequestParam(value = "type") String type) {
		return ResponseHelper.buildResponse(inspectionService.getMapByRegion(regionSeq, tableId, type));
	}
}
