package com.yeejoin.equipmanage.common.entity.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 树返回实体
 */
@Data
public class PointTreeVo {
    /**
     * 组态参数-component
     */
    private String template;
    /**
     * 组态参数-true
     */
    private boolean openStatus;
    /**
     * 组态参数-是否绑定
     */
    private boolean isBinding;


    @JsonProperty("isBinding")
    public boolean isBinding() {
        return isBinding;
    }

    public void setBinding(boolean binding) {
        isBinding = binding;
    }

    /**
     * 装备名称
     */
    private String displayName;
    /**
     * 页面展示大小
     */
    private String initStyle;
    /**
     * 组态参数-CommonEquip 装备
     */
    private String componentName;
    /**
     * id
     */
    private Long sequenceNbr;
    /**
     * 组态参数-equipment
     */
    private String componentKey;
    /**
     * 装备点图标
     */
    private String  imgPath;
    /**
     * 装备二维码
     */
    private String equipCode;
    /**
     * 装备分类id
     */
    private String equipId;
    /**
     * 装备分类code
     */
    private String categoryCode;
    /**
     * 装备类型名称
     */
    private String equipName;
    /**
     * 装备系统id
     */
    private String equipSyetemId;
    /**
     * 组态需要参数
     *        图片地址                  map.put("imgPath", fileUrl + p.getImgPath());
     *        装备唯一编码           map.put("equipCode", p.getEquipCode());
     *        装备详情api              map.put("detailApi", "http://" + equipmentdataUrl + p.getSequenceNbr());
     *        装备性能指标api       map.put("speindexApi", "http://" +speindexUrl + p.getSequenceNbr());
     *        装备系统id                map.put("equipSyetemId", p.getEquipSyetemId());
     *        装备类型id                map.put("equipTypeId", p.getEquipId());
     */
    private Map<String,Object> dataConfig;

    /**
     * 父id
     */
    private Long parentId;
    /**
     * 区域标识
     */
    private String isRegion;
    /**
     * 子数据
     */
    private List<PointTreeVo> children;

    /**
     * 画布信息
     */
    private  String content;

    /**
     * 部门code
     */
    private String orgCode;

    /**
     * 排序
     */
    private Long sort;

    /**
     * 画布id
     */
    private Long sceneId;

    /**
     * 状态
     */
    private String status;

    /**
     * iot码
     */
    private String iotCode;

    private String  key;

    private String groupId;

    private String groupName;


    private String ip;

    private String token;

    private String address;

    /**
     * 装备编码
     */
    private String code;
//建筑类型
    private String groupType;

    /**
     * 画布id
     */
    private String bizOrgCode;
}
