package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author DELL
 */

@Getter
@AllArgsConstructor
public enum ConfigPageTopicEnum {

    INTEGRATE("INTEGRATE_TOPIC/#", "集成页面统配主题"),
    SYSTEMDETAIL("EQUIP_INDEX_ON_SYSTEM_DETAIL", "系统详情页面大屏初始化主题");

	private String topic;

    private String describe;
    
    
    public static List<String> getEnumTopicList() {
        List<String> topics = new ArrayList<>();
        for (ConfigPageTopicEnum e : ConfigPageTopicEnum.values()) {
        	topics.add(e.getTopic());
       }
        return topics;
    }
    
    public static boolean  isEqualsTopic(String topic) {
        for (ConfigPageTopicEnum e : ConfigPageTopicEnum.values()) {
        	if(e.getTopic().equals(topic)){
        		 return true;
        	}
       }
        return false;
    }
}
