package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 项目坐标信息
 *
 * @author wangqian
 * @date 2021-01-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_coordinate")
@ApiModel(value = "ProjectCoordinate对象", description = "项目坐标信息")
public class ProjectCoordinate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "坐标地点位置")
    private String location;

    @ApiModelProperty(value = "考勤范围（米）")
    private Double clockScope;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "是否主坐标")
    private Boolean isMain;

    @ApiModelProperty(value = "备用字段")
    private String remark;

}
