package com.yeejoin.amos.knowledgebase.face.feign;

import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.*;

/**
 * @author 杨博超
 * @ClassName DataFillter
 * @Deacription 文档数据过参数组装
 **/
public interface DataFillter {

    String auditStatus = "auditStatus";
    String docStatus = "docStatus";
    String orgCode = "orgCode";
    String noData = "noData";
    String userId = "userId";


    Map<String, Object> assembleParams(List<String> roleNameList, String orgCode);


    /**
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author 杨博超
     * @description 根据角色过滤数据
     * @Param [auditStatus, docStatus]
     **/
    static Map<String, Object> dataFillterByRoleName(DataFillter dataFillter) {
        Map<String, Object> dataPrivilegemap = new HashMap<>();
        try {
            AgencyUserModel agencyUserModel = FeignUtil.remoteCall(() -> Privilege.agencyUserClient.queryByUserId(RequestContext.getExeUserId()));

            Map<Long, List<RoleModel>> map = agencyUserModel.getOrgRoles();
            Collection<List<RoleModel>> roleCollection = map.values();
            List<String> roleNameList = new ArrayList<>();
            for (List<RoleModel> list : roleCollection)
                for (RoleModel roleModel : list)
                    roleNameList.add(roleModel.getRoleName());

            String orgCodce = null;
            if (!ValidationUtil.isEmpty(agencyUserModel.getCompanyDepartments())
                    && !ValidationUtil.isEmpty(agencyUserModel.getCompanyDepartments().values())
                    && agencyUserModel.getCompanyDepartments().values().size() > 0
                    && !ValidationUtil.isEmpty(agencyUserModel.getCompanyDepartments().values().iterator().next().iterator().next())) {           //TODO  多部门多公司处理
                orgCodce = agencyUserModel.getCompanyDepartments().values().iterator().next().iterator().next().getOrgCode();
            } else if (!ValidationUtil.isEmpty(agencyUserModel.getCompanys())) {
                orgCodce = agencyUserModel.getCompanys().iterator().next().getOrgCode();
            }
            if(ValidationUtil.isEmpty(orgCodce))
                throw new RuntimeException("用户部门信息有误.");
            dataPrivilegemap.put(DataFillter.orgCode, orgCodce);
            if (!ValidationUtil.isEmpty(dataFillter))
                dataPrivilegemap = dataFillter.assembleParams(roleNameList, orgCodce);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("获取数据用户角色信息失败.");
        }
        return dataPrivilegemap;
    }



}
