package com.yeejoin.amos.maintenance.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.param.PlanInfoPageParam;
import com.yeejoin.amos.maintenance.business.service.intfc.IPlanService;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.business.util.PlanPageParamUtil;
import com.yeejoin.amos.maintenance.core.common.request.CommonPageable;
import com.yeejoin.amos.maintenance.core.common.request.CommonRequest;
import com.yeejoin.amos.maintenance.core.framework.PersonIdentify;
import com.yeejoin.amos.maintenance.dao.entity.Plan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping(value = "/api/plan")
@Api(tags = "巡检计划api")
public class PlanController extends AbstractBaseController {
    private final Logger log = LoggerFactory.getLogger(PlanController.class);
    @Autowired
    private IPlanService planService;

    /**
     * 巡检计划查询
     *
     * @param
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "巡检计划查询", notes = "巡检计划查询")
    @RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCheckInfoPage(@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
                                           @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        HashMap<String, Object> paramMap = buildMybatisCriterias(loginOrgCode, null);
//        buildRequestCxt();
        PlanInfoPageParam param = PlanPageParamUtil.fillPlanInfoParam(queryRequests, commonPageable, paramMap);
        Page<HashMap<String, Object>> list = planService.getPlanInfo(param);
        return CommonResponseUtil.success(list);
    }

    /**
     * 业主单位维保计划查询
     *
     * @param
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "业主单位维保计划查询", notes = "业主单位维保计划查询")
    @RequestMapping(value = "/owner/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryInfoPage(@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
                                           @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        HashMap<String, Object> paramMap = buildMybatisCriterias(null, null);
//        buildRequestCxt();
        PlanInfoPageParam param = PlanPageParamUtil.fillPlanInfoParam(queryRequests, commonPageable, paramMap);
        Page<HashMap<String, Object>> list = planService.getPlanInfo(param);
        return CommonResponseUtil.success(list);
    }

    /**
     * 巡检计划新增
     *
     * @param param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @ApiOperation(value = "巡检计划新增及编辑", notes = "巡检计划新增及编辑")
    @RequestMapping(value = "/addPlan", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse checkPlanAdd(@ApiParam(value = "巡检计划", required = true) @RequestBody Plan param) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            String loginOrgCode = getOrgCode(reginParams);
            HashMap<String, Object> map = new HashMap<String, Object>();
            param.setCompanyId(personIdentity.getCompanyId());
            param.setCompanyName(personIdentity.getCompanyName());
            map.put("org_code", loginOrgCode);
            map.put("user_id", RequestContext.getExeUserId());
            map.put("param", param);
            planService.addPlan(map);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("巡检计划新增失败");
        }
    }

    /**
     * 巡检计划删除（支持批量）
     *
     * @param param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除巡检计划", notes = "删除巡检计划")
    @RequestMapping(value = "/deletePlanById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deletePlanById(
            @ApiParam(value = "巡检计划ID", required = true) @RequestBody String[] param) {
        try {
            planService.delPlanById(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检计划失败");
        }
    }


    /**
     * 编辑巡检另存(支持批量)
     *
     * @param param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "另存巡检计划", notes = "另存巡检计划")
    @RequestMapping(value = "/saveAs", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse planSaveAs(@ApiParam(value = "参数", required = true) @RequestBody String[] param) {
        try {
            planService.planSaveAs(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("另存巡检计划失败");
        }
    }

    /**
     * 根据id查询巡检计划
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询维保计划明细", notes = "查询维保计划明细")
    @RequestMapping(value = "/detail/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryPointById(@ApiParam(value = "计划id", required = true) @PathVariable(name = "id") Long id) {

        Plan plan = planService.queryPlanById(id);
        return CommonResponseUtil.success(plan);

    }

    /**
     * 巡检计划查询
     *
     * @param
     * @param param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "巡检计划查询", notes = "巡检计划查询")
    @RequestMapping(value = "/queryPlanByOrgCode", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCheckInfo(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        HashMap<String, Object> paramMap = buildMybatisCriterias(loginOrgCode, null);
        PlanInfoPageParam param = PlanPageParamUtil.fillPlanInfoParam(queryRequests, null, paramMap);
        List<HashMap<String, Object>> list = planService.getPlanInfoNoPage(param);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询计划列表(<font color='blue'>手机app</font>)", notes = "查询计划列表(<font color='blue'>手机app</font>)")
    @RequestMapping(value = "/queryPlanList", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryPlanList() {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        List<HashMap<String, Object>> list = planService.queryPlanListByOrgCode(loginOrgCode);
        return CommonResponseUtil.success(list);
    }

}
