package com.yeejoin.amos.maintenance.feign;

import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import com.yeejoin.amos.maintenance.business.param.PushMsgParam;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("pushFeignServer")
public class PushFeignServer {
	public void sendMessage(List<PushMsgParam> pushMsgParam){
		 try {
			    pushMsgParam.forEach(action->{
			    	sendJP(action);
			    });
			} catch (Exception e) {
				e.printStackTrace();	 
			}
	}
   
   
	public void sendMessage(PushMsgParam pushMsgParam){
		 try {
			 sendJP(pushMsgParam);
			} catch (Exception e) {
				e.printStackTrace();	 
			}
	}
   
   private void sendJP(PushMsgParam pushMsgParam){
	   	MessageModel model = new MessageModel();
	   	model.setRelationId(pushMsgParam.getRelationId());
	   	model.setTitle(pushMsgParam.getSubject());
	   	model.setBody(pushMsgParam.getContent());
	   	model.setMsgType("maintenance");
	   	model.setIsSendApp(true);
	   	model.setIsSendWeb(true);
	   	model.setRecivers(pushMsgParam.getRecivers());
	   	model.setExtras(pushMsgParam.getExtras());
	    Systemctl.messageClient.create(model);
   }	
}
