package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
* 
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WaterResourceNaturalDto", description="天然水源")
public class WaterResourceNaturalDto  extends BaseDto {

   private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "资源id")
    private Long resourceId;

    @ApiModelProperty(value = "高度（cm）")
    private Float height;

    @ApiModelProperty(value = "水源类型代码")
    private String typeCode;

    @ApiModelProperty(value = "水源类型")
    private String type;

    @ApiModelProperty(value = "容积（m³）")
    private Float volume;

    @ApiModelProperty(value = "面积（㎡）")
    private Float area;

    @ApiModelProperty(value = "水质情况")
    private String qualitySituationInfo;

    @ApiModelProperty(value = "四季变化简要情况")
    private String seasonChangeInfo;

    @ApiModelProperty(value = "水源可用状态类别代码")
    private String statusCode;

    @ApiModelProperty(value = "水源可用状态类别名称")
    private String status;

    @ApiModelProperty(value = "有无枯水期")
    private Boolean hasDrySeason;

    @ApiModelProperty(value = "枯水期跨度简要情况")
    private String dryPeriodSpan;

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

}
