package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * The persistent class for the p_check_input database table.
 *
 */
@Entity
@Table(name="p_check_input_history")
public class CheckInputHistory implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 巡检记录id
     */
    @Column(name="check_id")
    private Long checkId;

    /**
     * 检查项id
     */
    @Column(name="input_id")
    private Long inputId;


    /**
     * 检查项名称
     */
    @Column(name="input_name")
    private String inputName;

    /**
     * 巡检点检查项
     */
    @Column(name="route_point_item_id")
    private Long routePointItemId;

    /**
     * 输入值
     */
    @Column(name="input_value")
    private String inputValue;

    /**
     * 是否合格
     */
    @Column(name="is_ok")
    private String isOk;

    /**
     * 序号
     */
    @Column(name="order_no")
    private int orderNo;

    /**
     * 权限系统org code
     */
    @Column(name="org_code")
    private String orgCode;

    /**
     * 检查点分类id
     */
    @Column(name="point_classify_id")
    private Long pointClassifyId;

    /**
     * 检查点分类名称
     */
    @Column(name="point_classify_name")
    private String pointClassifyName;

    /**
     * 评分
     */
    private int score;

    /**
     * 备注
     */
    private String remark;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public CheckInputHistory() {
    }


    public Long getCheckId() {
        return this.checkId;
    }

    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    public Long getInputId() {
        return this.inputId;
    }

    public void setInputId(Long inputId) {
        this.inputId = inputId;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public String getIsOk() {
        return this.isOk;
    }

    public void setIsOk(String isOk) {
        this.isOk = isOk;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getInputName() {
        return inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public Long getRoutePointItemId() {
        return routePointItemId;
    }

    public void setRoutePointItemId(Long routePointItemId) {
        this.routePointItemId = routePointItemId;
    }

    public Long getPointClassifyId() {
        return pointClassifyId;
    }

    public void setPointClassifyId(Long pointClassifyId) {
        this.pointClassifyId = pointClassifyId;
    }

    public String getPointClassifyName() {
        return pointClassifyName;
    }

    public void setPointClassifyName(String pointClassifyName) {
        this.pointClassifyName = pointClassifyName;
    }

    /**
     * id
     */
    private long id;

    @CreatedDate
    @Column(name="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @Id
    @Column(name = "ID",nullable=false,unique=true)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

}