package com.yeejoin.amos.boot.module.cylinder.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 气瓶区域统计表
 *
 * @author system_generator
 * @date 2022-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderAreaDataDto", description="气瓶区域统计表")
public class CylinderAreaDataDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "区域名称")
    private String areaName;

    @ApiModelProperty(value = "企业数量")
    private Long unitNum;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "父节点区域编码")
    private String parentRegionCode;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "气瓶数量")
    private Long cylinderNum;

    @ApiModelProperty(value = "预警数量")
    private Long warnNum;

    @ApiModelProperty(value = "区域层级")
    private String level;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "超期数量")
    private Integer outOfDateNum;

}
