package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class CylinderCategoryConverter implements Converter<String> {

    private static final String LPG_CYLINDER = "液化石油气瓶";
    private static final String INDUSTRY_CYLINDER = "工业气瓶";
    private static final String OTHER = "其他";


    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                     GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        if (LPG_CYLINDER.equals(cellValue)) {
            return "0";
        } else if (INDUSTRY_CYLINDER.equals(cellValue)) {
            return "1";
        }else if (OTHER.equals(cellValue)){
            return "2";
        }
        return null;
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 判断实体类中获取的值，转换为Excel预期的值，并封装为CellData对象
        if (o == null) {
            return new CellData("");
        } else if (o.equals("0")) {
            return new CellData(LPG_CYLINDER);
        } else if (o.equals("1")) {
            return new CellData(INDUSTRY_CYLINDER);
        }else if (o.equals("2")) {
            return new CellData(OTHER);
        }
        return new CellData("");
    }
}