package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.statistics.api.dto.CylinderFillingMessageModel;
import com.yeejoin.amos.boot.module.statistics.api.mapper.CylinderStatisticsMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;

@DS("openapi")
@Service
public class CylinderOpenApiServiceImpl {

    private final CylinderStatisticsMapper cylinderStatisticsMapper;

    public CylinderOpenApiServiceImpl(CylinderStatisticsMapper cylinderStatisticsMapper) {
        this.cylinderStatisticsMapper = cylinderStatisticsMapper;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public IPage<CylinderFillingMessageModel> getUploadCylinderLogsByOrgCode(Page<CylinderFillingMessageModel> page, @Condition(Operator.likeRight) String orgCode) {
        return cylinderStatisticsMapper.getUploadCylinderLogsPage(page, orgCode);
    }
}
