package com.yeejoin.amos.video.entity;

import java.util.Date;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 模板表
 *
 * @author system_generator
 * @date 2021-09-01
 */
@Data
@Accessors(chain = true)
@Document(indexName = "video", type = "videoOriginal", shards = 1, replicas = 0)
public class VideoOriginal {
    /** 主键 */
    @Id
    private String sequenceNbr;

	/**
	 * 视频名称
	 */
	@Field(type = FieldType.Keyword)
	private String cn;

	/**
	 * 视频代码
	 */
	@Field(type = FieldType.Text)
	private String indexCode;

	/**
	 * 原始数据
	 */
	@Field(type = FieldType.Text, index = false)
	private String originalData;
	@Field(type = FieldType.Text, index = false)
	private String recDate;
	@Field(type = FieldType.Text, index = false)
	private String recUserId;
	@Field(type = FieldType.Text, index = false)
	private String recUserName;

}
