package com.yeejoin.amos.boot.module.jczs.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author litw
 * @date 2021-09-29.
 */
@Data
public class ElevatorStatusHandleDto {

    @ApiModelProperty(value = "当前电梯运行模式。1：停止服务 2：正常运行 3：检修 4：消防返回 5：消防员运行 6：应急电源运行 7：地震模式 8: 未知")
    private String serviceModel;

    @ApiModelProperty(value = "轿厢运行状态。1：停止，2：运行")
    private String liftStatus;

    @ApiModelProperty(value = "轿厢运行方向。1：无方向 2：上行 3：下行")
    private String liftDirection;

    @ApiModelProperty(value = "轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区")
    private String isZone;

    @ApiModelProperty(value = "关门到位 1：关门到位，0：无关门到位信号")
    private String doorStatus;

    @ApiModelProperty(value = "轿厢内是否有人 0：无，1：有")
    private String personFlag;

    @ApiModelProperty(value = "当前物理楼层")
    private Integer currFloor;
}
