package com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.service;

import java.util.Set;

public abstract class DefaultQualityScoreUpdateService implements IQualityScoreUpdate {

    /**
     *  前置处理-定义目前支持的业务类型，由于目前仅实现使用登记、新增设备、新增装置、大编辑设备、大编辑装置、安装告知准则，
     *  所有都实现后返回true即可
     * @param bizType 业务类型
     * @return 是否通过前置检验
     */
    protected abstract Boolean shouldProcess(String bizType);

    public void doUpdate(String bizType, Set<String> recordOrPIds) {
        if (shouldProcess(bizType)) {
            doHandle(bizType, recordOrPIds);
        }
        afterHandle(recordOrPIds);
    }

    /**
     * 执行
     * @param bizType 业务类型
     * @param recordOrPIds 装置或者设备id集合
     */
    protected abstract void doHandle(String bizType, Set<String> recordOrPIds);

    /**
     * 事后处理
     * @param recordOrPIds 装置或者设备id集合
     */
    protected abstract void afterHandle(Set<String> recordOrPIds);
}
