package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-压力管道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("8000")
public class PipelineTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "pipeName", label = "管道名称（登记单元）", type = TechnicalParameter.ParamType.STRING)
    private String pipeName;


    @TechnicalParameter(key = "pipelineNumber", label = "管道编号", type = TechnicalParameter.ParamType.STRING)
    private String pipelineNumber;


    @TechnicalParameter(key = "deviceLevel", label = "管道级别", type = TechnicalParameter.ParamType.STRING, dictCode = "8100,8200,8300")
    private String deviceLevel;


    @TechnicalParameter(key = "nominalDiameter", label = "公称直径", type = TechnicalParameter.ParamType.STRING)
    private String nominalDiameter;


    @TechnicalParameter(key = "wallThickness", label = "公称壁厚", type = TechnicalParameter.ParamType.STRING)
    private String wallThickness;


    @TechnicalParameter(key = "pipeLength", label = "管道长度", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m")
    private BigDecimal pipeLength;


    @TechnicalParameter(key = "pressure", label = "设计压力", type = TechnicalParameter.ParamType.STRING,unit = "Mpa")
    private String pressure;


    @TechnicalParameter(key = "temperature", label = "设计温度", type = TechnicalParameter.ParamType.STRING)
    private String temperature;


    @TechnicalParameter(key = "medium", label = "设计介质", type = TechnicalParameter.ParamType.STRING)
    private String medium;


    @TechnicalParameter(key = "workPressure", label = "工作压力", type = TechnicalParameter.ParamType.STRING)
    private String workPressure;


    @TechnicalParameter(key = "workTemperature", label = "工作温度", type = TechnicalParameter.ParamType.STRING)
    private String workTemperature;


    @TechnicalParameter(key = "workMedium", label = "工作介质", type = TechnicalParameter.ParamType.STRING)
    private String workMedium;


    @TechnicalParameter(key = "remarks", label = "备注", type = TechnicalParameter.ParamType.STRING)
    private String remarks;

}
