package com.yeejoin.amos.boot.module.cylinder.biz.listener;

import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderQuestionInfoDto;
import com.yeejoin.amos.boot.module.cylinder.api.enums.QuestionTypeEnum;
import com.yeejoin.amos.boot.module.cylinder.biz.event.CylinderQuestionCreateEvent;
import com.yeejoin.amos.boot.module.cylinder.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.enums.CyclinderStatus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class CylinderFillingInsertListenerForQuestion implements ICylinderFillingInsertListener {


    private EventPublisher eventPublisher;

    public CylinderFillingInsertListenerForQuestion(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }


    @Override
    public void handle(CylinderFillingRecordDto cylinderFillingRecordDto) {
        if (CyclinderStatus.HEGE.getName().equals(cylinderFillingRecordDto.getFillingResult()) && CyclinderStatus.HEGE.getName().equals(cylinderFillingRecordDto.getCheckResult())) {
            log.info("气瓶充装信息前后全部合格，不创建问题！");
        } else {
            CylinderQuestionInfoDto questionInfo = new CylinderQuestionInfoDto();
            questionInfo.setQuestionType(QuestionTypeEnum.CZJCBHG.getCode());
            questionInfo.setQuestionTypeName(QuestionTypeEnum.CZJCBHG.getName());
            questionInfo.setQuestionAttributionId(cylinderFillingRecordDto.getAppId());
            questionInfo.setQuestionAttributionName(cylinderFillingRecordDto.getFillingUnitName());
            questionInfo.setRegionCode(cylinderFillingRecordDto.getRegionCode());
            questionInfo.setQuestionObjectId(cylinderFillingRecordDto.getSequenceCode());
            questionInfo.setHappenDate(cylinderFillingRecordDto.getSyncDate());
            eventPublisher.publish(new CylinderQuestionCreateEvent(this, questionInfo));
        }
    }
}
