package com.yeejoin.amos.boot.module.cylinder.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 施工信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="constructionInfo", description="最近施工信息")
public class ConstructionInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "施工类型")
    private String constructionType;
    @ApiModelProperty(value = "施工单位统一社会信用代码")
    private String uscUnitCreditCode;
    @ApiModelProperty(value = "施工单位")
    private String uscUnitName;
    @ApiModelProperty(value = "施工时间")
    private Date uscDate;

    @ApiModelProperty(value = "")
    private String uscInformId;

}
