package com.yeejoin.amos.boot.module.command.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.util.Date;

/**
 * @description:
 * @author: tw
 * @createDate: 2021/7/19
 * 地震气象信息
 */
@Data
@ApiModel(value = "SeismometeorologyDto", description = "地震气象信息")
@Document(collection = "heart_rate")
public class SeismometeorologyDto {


    @MongoId
    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "预警类型 1：警情通知 0：气象通知")
    @Field("type")
    private String type;

    @ApiModelProperty(value = "预警类型名称")
    @Field("typeName")
    private String typeName;

    @ApiModelProperty(value = "预警等级")
    @Field("grade")
    private String grade;

    @ApiModelProperty(value = "发布时间")
    @Field("releaseTime")
    private Date releaseTime;

    @ApiModelProperty(value = "发布单位")
    @Field("releaseCompany")
    private String releaseCompany;

    @ApiModelProperty(value = "发布内容")
    @Field("content")
    private String content;
    
   



    public SeismometeorologyDto(Long sequenceNbr, String type, String typeName, String grade, Date releaseTime, String releaseCompany, String content) {
        this.sequenceNbr = sequenceNbr;
        this.type = type;
        this.typeName = typeName;
        this.grade = grade;
        this.releaseTime = releaseTime;
        this.releaseCompany = releaseCompany;
        this.content = content;
    }

    public SeismometeorologyDto() {
    }
}
