package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * '
 *
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FireChemicalDto", description = "危化品")
public class FireChemicalDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "casNo")
    @ExcelProperty(value = "casNo", index = 1)
    private String casNo;

    @ApiModelProperty(value = "国际危险号")
    @ExcelProperty(value = "国际危险号", index = 2)
    private String dangerId;

    @ApiModelProperty(value = "防护处理")
    @ExcelProperty(value = "防护处理", index = 3)
    private String defendWay;

    @ApiModelProperty(value = "处理措施")
    @ExcelProperty(value = "处理措施", index = 4)
    private String dispose;

    @ApiModelProperty(value = "英文名")
    @ExcelProperty(value = "英文名", index = 5)
    private String englishName;

    @ApiModelProperty(value = "分子式")
    @ExcelProperty(value = "分子式", index = 6)
    private String formula;

    @ApiModelProperty(value = "主要成分")
    @ExcelProperty(value = "主要成分", index = 7)
    private String ingredient;

    @ApiModelProperty(value = "泄漏处理")
    @ExcelProperty(value = "泄漏处理", index = 8)
    private String leakWay;
    @ExcelProperty(value = "中文名", index = 0)
    @ApiModelProperty(value = "中文名")
    private String name;

    @ApiModelProperty(value = "性状")
    @ExcelProperty(value = "性状", index = 9)
    private String property;

    @ApiModelProperty(value = "贮藏方法")
    @ExcelProperty(value = "贮藏方法", index = 10)
    private String store;

    @ApiModelProperty(value = "症状")
    @ExcelProperty(value = "症状", index = 11)
    private String symptom;

    @ApiModelProperty(value = "禁忌物/禁忌")
    @ExcelProperty(value = "禁忌物/禁忌", index = 12)
    private String tabu;
    @ExcelIgnore
    @ApiModelProperty(value = "类型code")
    private String typeCode;

    @ExplicitConstraint(type = "CHEMICALTYPE", indexNum = 13, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ApiModelProperty(value = "类型名称")
    @ExcelProperty(value = "类型名称", index = 13)
    private String type;
    //    @ExplicitConstraint(indexNum=14,source = {"男","女"}) //固定下拉内容
    @ExcelProperty(value = "国标号", index = 14)
    @ApiModelProperty(value = "国标号")
    private String un;

    @ApiModelProperty(value = "化学品图片")
    @ExcelProperty(value = "化学品图片", index = 15)
    private String image;
    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;


}
