package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsrExcelDto", description="机构/部门/人员表")
public class OrgUsrExcelDto extends BaseDto {

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ExcelIgnore
    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType;

    @ExcelIgnore
    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;
    @ExcelIgnore
    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ExcelProperty(value = "所属单位部门", index = 1)
    @ExplicitConstraint(indexNum = 1, sourceClass = RoleNameExplicitConstraint.class, method = "getparent") //固定下拉内容
    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性1")
    private String orgExpandAttr1;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性2")
    private String orgExpandAttr2;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性3")
    private String orgExpandAttr3;
    @ExcelIgnore
    @ApiModelProperty(value = "扩展属性4")
    private String orgExpandAttr4;
    @ExcelIgnore
    private String orgExpandAttr5;
    @ExcelIgnore
    private String orgExpandAttr6;
    @ExcelIgnore
    private String orgExpandAttr7;
    @ExcelIgnore
    private String orgExpandAttr8;
    @ExcelIgnore
    @ApiModelProperty(value = "更新人")
    @TableField(fill= FieldFill.INSERT_UPDATE)
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "动态表单值")
    private List<DynamicFormInstance> dynamicFormValue;


    @ExcelProperty(value = "行政职务", index = 2)
    @ExplicitConstraint(type = "XZZW", indexNum =2, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String  administrativePositionCode;//	行政职务
    @ExcelProperty(value = "审核周期", index = 3)
    @ExplicitConstraint(type = "SHZQ", indexNum =3, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String  auditCycle;	//审核周期
    @ExcelProperty(value = "证件号码", index = 4)
    private String  certificatesNumber;//	证件号码
    @ExcelProperty(value = "证件类型", index = 5)
    @ExplicitConstraint(type = "RYZJLX", indexNum =5, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String certificatesTypeCode;	//证件类型
    @ExcelProperty(value = "持证类别", index = 6)
    @ExplicitConstraint(type = "CZLB", indexNum =6, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String certificateType;	//持证类别
    @ExcelProperty(value = "消防管理岗位", index = 7)
    @ExplicitConstraint(type = "XFGLGW", indexNum =7, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String fireManagementPostCode;	//消防管理岗位
    @ExcelProperty(value = "性别", index = 8)
    @ExplicitConstraint(type = "XB", indexNum =8, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String gender;	//性别
    @ExcelProperty(value = "消防管理组织机构内部职务", index = 9)
    @ExplicitConstraint(type = "JGNBZW", indexNum =9, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String  internalPositionCode;	//消防管理组织机构内部职务
    @ExcelProperty(value = "员工编号", index = 10)
    private String personNumber;	//员工编号
    @ExcelProperty(value = "岗位类型", index = 11)
    @ExplicitConstraint(type = "GWMC", indexNum =11, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String  positionType;	//岗位类型
    @ExcelProperty(value = "是否进行安全培训", index = 12)
    @ExplicitConstraint(type = "AQPX", indexNum =12, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String  safetyTraining;	//是否进行安全培训
    @ExcelProperty(value = "人员状态", index = 13)
    @ExplicitConstraint(type = "RYZT", indexNum =13, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内
    private String stateCode;	//人员状态
    @ExcelProperty(value = "联系电话", index = 14)
    private String  telephone;	//联系电话













}
