package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CheckEmailEnum {
	ALL("checkEmail","all", "有上报就推送"),
	LEAK("checkEmail","leak", "漏检上报"),
	ERROR("checkEmail","error", "不合格上报"),
	NOT("checkEmail","not", "全部不推送");
	
	private String ower;
	private String code;
	private String message;
	
	private CheckEmailEnum(String ower, String code, String message) {
		this.ower = ower;
		this.code = code;
		this.message = message;
	}

	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public String getOwer() {
		return ower;
	}
	
	public static List<Map<String, Object>> getEnumList() {
		List<Map<String, Object>> list = new ArrayList<>();
		for(CheckEmailEnum e : CheckEmailEnum.values()) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("ower", e.getOwer());
			map.put("code", e.getCode());
			map.put("message", e.getMessage());
			list.add(map);
		}
		return list;
	}
}
