package com.yeejoin.amos.boot.module.command.biz.service.impl;

import com.yeejoin.amos.boot.biz.common.utils.FileService;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;

import org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi.ecCVCDSA;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/***
 *
 * 平台安全接口实现类
 *
 * ***/
@Service("remoteSecurityService")
public class RemoteSecurityService  implements FileService{

	@Override
	public String uploadFile(MultipartFile file,String product,String appKey,String token ) {
		 try {           
			 
			 
			    RequestContext.setProduct(product);
	            RequestContext.setAppKey(appKey);
	            RequestContext.setToken(token);
	            FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFile(file);
	            String urlString="";
	    		if (date != null) {
	    			Map<String, String> map = date.getResult();
	    			Iterator<String> it = map.keySet().iterator();
	    			while (it.hasNext()) {
	    				urlString=it.next();
	    			}
	    		}
	             return urlString;
	        } catch (Exception e) {  
	        	e.printStackTrace();
	            throw new RuntimeException();
	        }
	}

   
}
