package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureRepairlogDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.entity.FailureRepairlog;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureRepairlogMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureRepairlogService;

/**
 * 流程日志服务实现类
 *
 * @author system_generator
 * @date 2021-08-12
 */
@Service
@Transactional
public class FailureRepairlogServiceImpl extends BaseService<FailureRepairlogDto,FailureRepairlog,FailureRepairlogMapper> implements IFailureRepairlogService {
    /**
     * 分页查询
     */
    public Page<FailureRepairlogDto> queryForFailureRepairlogPage(Page<FailureRepairlogDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FailureRepairlogDto> queryForFailureRepairlogList()   {
        return this.queryForList("" , false);
    }

    /**
     * 根据FaultId查询
     */
    public List<FailureRepairlog> findByfaultIdLog(Long faultId) {
        Page<FailureRepairlogDto> page = new Page<>();
        QueryWrapper<FailureRepairlog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fault_id", faultId).orderByAsc("process_time");
        return baseMapper.selectList(queryWrapper);
    }
    
    
    public FailureRepairlog findByprocessAuditor(String userId) {
         LambdaQueryWrapper<FailureRepairlog> queryWrapper = new LambdaQueryWrapper<FailureRepairlog>();
         queryWrapper.eq(FailureRepairlog::getProcessAuditor, userId);
         queryWrapper.last("LIMIT 1");
         return  baseMapper.selectOne(queryWrapper);
    }
    public FailureRepairlog findByFaultId(Long faultId) {
        LambdaQueryWrapper<FailureRepairlog> wrapper = new LambdaQueryWrapper<FailureRepairlog>();
        wrapper.eq(FailureRepairlog::getIsDelete, false);
        wrapper.eq(FailureRepairlog::getFaultId, faultId);
        wrapper.orderByAsc(FailureRepairlog::getProcessTime);
        wrapper.last("LIMIT 1");
        return this.baseMapper.selectOne(wrapper);
    }
}