package com.yeejoin.amos.fas.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.constants.FasConstant;
import com.yeejoin.amos.fas.business.dao.mapper.EvaModelMapper;
import com.yeejoin.amos.fas.business.dao.repository.IEvaluationModelDao;
import com.yeejoin.amos.fas.business.service.intfc.IEvaModelService;
import com.yeejoin.amos.fas.core.util.StringUtil;
import com.yeejoin.amos.fas.dao.entity.EvaluationModel;

@Service("evaModelService")
public class EvaModelServiceImpl implements IEvaModelService {

	@Autowired 
	EvaModelMapper evaModelMapper;
	
	@Autowired
	IEvaluationModelDao iEvaluationModelDao;
	@Override
	public HashMap<String, Object> queryFmeaByType(String type) {
		 HashMap<String, Object> map =  new HashMap<String, Object>();
		if(!StringUtil.isNotEmpty(type)){
			String sInfoJson = evaModelMapper.getSInfo();
			String oInfoJson = evaModelMapper.getOInfo();
			String dInfoJson = evaModelMapper.getDInfo();
	        List<HashMap> sList =JSON.parseArray(sInfoJson, HashMap.class);
	        List<HashMap> oList =JSON.parseArray(oInfoJson, HashMap.class);
	        List<HashMap> dList =JSON.parseArray(dInfoJson, HashMap.class); 
	        map.put(FasConstant.EVA_MODEL_S, sList);
	        map.put(FasConstant.EVA_MODEL_O, oList);
	        map.put(FasConstant.EVA_MODEL_D, dList);
        }else{
        	String json = "";
        	if(FasConstant.EVA_MODEL_S.equals(type)){
        		json = evaModelMapper.getSInfo();
        	}else if(FasConstant.EVA_MODEL_O.equals(type)){
        		json = evaModelMapper.getOInfo();
        	}else if(FasConstant.EVA_MODEL_D.equals(type)){
        		json = evaModelMapper.getDInfo();
        	}
        	List<HashMap> list =JSON.parseArray(json, HashMap.class);
        	if(null != list && list.size()>0){
        		map.put(type, list);
        	}	
        }
		return map;
	}
	
	@Override
	public HashMap<String, Object> findFmeaByType(String type) {
		 HashMap<String, Object> map =  new HashMap<String, Object>();
		if(!StringUtil.isNotEmpty(type)){
	        List<EvaluationModel> sList =iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_S);
	        List<EvaluationModel> oList =iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_O);
	        List<EvaluationModel> dList =iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_D);
	        map.put(FasConstant.EVA_MODEL_S, sList);
	        map.put(FasConstant.EVA_MODEL_O, oList);
	        map.put(FasConstant.EVA_MODEL_D, dList);
        }else{
        	List<EvaluationModel> list = new ArrayList<>();;
        	if(FasConstant.EVA_MODEL_S.equals(type)){
        		list = iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_S);
        	}else if(FasConstant.EVA_MODEL_O.equals(type)){
        		list = iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_O);
        	}else if(FasConstant.EVA_MODEL_D.equals(type)){
        		list = iEvaluationModelDao.findAllByType(FasConstant.EVA_MODEL_D);
        	}
        	if(null != list && list.size()>0){
        		map.put(type, list);
        	}	
        }
		return map;
	}

}
