package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.repository.IStationMaintenDao;
import com.yeejoin.amos.fas.business.service.intfc.IStationMaintenService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.StationInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;


@Service("stationMaintenService")
public class StationMaintenServiceImp implements IStationMaintenService {

    @Autowired
    private IStationMaintenDao iStationMaintenDao;

    @Override
    public void save(StationInfo stationInfo){
        StringBuilder stringBuilder = new StringBuilder();
        Integer useType = stationInfo.getUseType();
        String regionCode = stationInfo.getRegionCode();
        String code = stationInfo.getCode();
        if (regionCode == null || "".equals(regionCode) ){
            StationInfo station = detail();
            stationInfo.setStationCode(station.getStationCode());
        }else {
            stringBuilder.append(useType);
            stringBuilder.append(regionCode);
            stringBuilder.append(code);
            stationInfo.setStationCode(stringBuilder.toString());
        }


//        // 状态为启用（0）下只能修改换流站名称
//        if(stationInfo.getId() == 0){
//            StringBuilder stringBuilder = new StringBuilder();
//            stringBuilder.append(stationInfo.getUseType());
//            stringBuilder.append(stationInfo.getRegionCode());
//            stringBuilder.append(stationInfo.getCode());
//            stationInfo.setStationCode(stringBuilder.toString());
//        }else{
//            StationInfo station = detail();
//            // 判断状态是否切换
//            if(!station.getStatus().equals(stationInfo.getStatus())){
//                StringBuilder stringBuilder = new StringBuilder();
//
//                if(StringUtils.isEmpty(stationInfo.getRegionCode())){
//                    stringBuilder.append(station.getStationCode());
//                }else{
//                    stringBuilder.append(stationInfo.getUseType());
//                    stringBuilder.append(stationInfo.getRegionCode());
//                    stringBuilder.append(stationInfo.getCode());
//                }
//
//                stationInfo.setStationCode(stringBuilder.toString());
//            }
//        }

        //保存
        iStationMaintenDao.save(stationInfo);
    }

    @Override
    public StationInfo detail(){
        List<StationInfo> list = iStationMaintenDao.findAll();
        if(list != null && !ObjectUtils.isEmpty(list)) {
            return list.get(0);
        }else{
            return new StationInfo();
        }
    }
}
