package com.yeejoin.amos.knowledgebase.face.util;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * <h1>定制化配置信息加载器<h1>
 *
 * @author tiantao
 * @date 2021/1/7 9:33
 */
@Getter
@Component
@PropertySource(value = "classpath:customization.properties", encoding = "UTF-8")
public class ConfigLoader {

    private boolean sync;
    private String tags;
    private String projects;
    private boolean tagWithName;
    private String agencyCode;

    @Value("${system-conf.rule.sync}")
    public void setSync(boolean sync) {
        this.sync = sync;
    }

    @Value("${system-conf.rule.source.tags}")
    public void setTags(String tags) {
        this.tags = tags;
    }

    @Value("${system-conf.rule.target.projects}")
    public void setProjects(String projects) {
        this.projects = projects;
    }

    @Value("${system-conf.rule.source.tag-with-name}")
    public void setTagWithName(boolean tagWithName) {
        this.tagWithName = tagWithName;
    }

    @Value("${system-conf.rule.target.agency-code}")
    public void setAgencyCode(String agencyCode) {
        this.agencyCode = agencyCode;
    }
}
