package com.yeejoin.amos.knowledgebase.face.util;

import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.Numbering;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 导入导出配置
 * @author tiantao
 */
public class IOConfig {
    /**
     * 列表样式与前端匹配
     */
    public static final Map<String, Long> NUM_MAP;
    public static final Map<String, Long> ILV1_MAP;
    /**
     * 列表样式
     */
    public static final NumberingDefinitionsPart INIT_NUMBERING_DEFINITION;
    /**
     * 图片服务器路径
     */
    public static String PIC_URI = "http://39.98.246.31:8888/";

    /**
     * 图片服务器路由
     */
    public static String PIC_ROUTER = "/fileURI/";

    static {
        Map<String, Long> tmp1 = new HashMap<>();
        tmp1.put("ul", 1L);
        tmp1.put("ol", 2L);
        NUM_MAP = Collections.unmodifiableMap(tmp1);
        Map<String, Long> tmp2 = new HashMap<>();
        tmp2.put("square", 1L);
        tmp2.put("disc", 2L);
        tmp2.put("circle", 3L);
        tmp2.put("lower-alpha", 1L);
        tmp2.put("lower-roman", 2L);
        tmp2.put("upper-alpha", 3L);
        tmp2.put("upper-roman", 4L);
        tmp2.put("lower-greek", 1L);
        ILV1_MAP = Collections.unmodifiableMap(tmp2);
        NumberingDefinitionsPart numberingDefinitionsPart = null;
        try {
            numberingDefinitionsPart = new NumberingDefinitionsPart();
            InputStream is = IOConfig.class.getClassLoader().getResourceAsStream("office/listStyle.xml");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            String str;
            while ((str = reader.readLine()) != null) {
                builder.append(str);
            }
            Numbering numbering = (Numbering) XmlUtils.unmarshalString(builder.toString());
            numberingDefinitionsPart.setJaxbElement(numbering);
        } catch (Exception e) {
            e.printStackTrace();
        }
        INIT_NUMBERING_DEFINITION = numberingDefinitionsPart;
    }
}
