package com.yeejoin.amos.maintenance.business.service.impl;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.maintenance.business.feign.EquipFeignClient;
import com.yeejoin.amos.maintenance.business.service.intfc.IStatisticsService;
import com.yeejoin.amos.maintenance.common.enums.PlanTaskDetailIsFinishEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class StatisticsServiceImpl implements IStatisticsService {

    @Autowired
    PlanTaskMapper planTaskMapper;
    @Autowired
    EquipFeignClient equipFeign;

    @Override
    public Map<String, Object> taskStatusStatistics(ReginParams.PersonIdentity opIdentifyInfo, String orgCode) {
        Map<String, Object> param = Bean.BeantoMap(opIdentifyInfo);
        param.put("orgCode", orgCode);
        List<Map<String, Object>> list = planTaskMapper.statisticsTaskWithAuth(param);
        Map<Integer, Long> statusNumberMap = list.stream().collect(Collectors.toMap(map -> Integer.parseInt(map.get("is_finish").toString()), v -> Long.parseLong(v.get("total").toString())));
        Map<String, Object> resultMap = new HashMap<>();
        // 待执行任务数量
        resultMap.put("waitExecuteTask", statusNumberMap.get(PlanTaskDetailIsFinishEnum.UNFINISHED.getValue()) == null ? 0L : statusNumberMap.get(PlanTaskDetailIsFinishEnum.UNFINISHED.getValue()));
        // 超时任务数量
        resultMap.put("overTimeTask", statusNumberMap.get(PlanTaskDetailIsFinishEnum.OVERTIME.getValue()) == null ? 0L : statusNumberMap.get(PlanTaskDetailIsFinishEnum.OVERTIME.getValue()));
        ResponseModel<List<Map<String, Object>>> response = equipFeign.overTimeMaintenanceFacility(opIdentifyInfo.getIdentityType(),opIdentifyInfo.getCompanyId());
        List<Map<String, Object>> overTimeFacility = response.getResult();
        // 到期维保设备
        resultMap.put("overTimeFacility", overTimeFacility.size());
        return resultMap;
    }
}
