package com.yeejoin.amos.maintenance.business.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 消防设施资源数据对象 mt_maintenance_resource_data
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
@Data
@ApiModel(value = "MaintenanceResourceDataVo", description = "维保设施资源数据Vo")
public class MaintenanceResourceData {

    private Long id;

    /**
     * 维保资源ID
     */
    private Long maintenanceResourceId;

    /**
     * 维保单位ID
     */
    private Long maintenanceCompanyId;

    /**
     * 维保单位编码
     */
    private String maintenanceCompanyCode;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 业主单位ID
     */
    private Long ownerUnitId;

    /**
     * 业主单位编码
     */
    private String ownerUnitCode;

    /**
     * 业主单位名称
     */
    private String ownerUnitName;

    /**
     * 消防系统ID
     */
    private Long fireFightSysId;

    /**
     * 消防系统编码
     */
    private String fireFightSysCode;

    /**
     * 消防系统名称
     */
    private String fireFightSysName;

    /**
     * 分类ID
     */
    private Long classifyId;

    /**
     * 分类编码
     */
    private String classifyCode;

    /**
     * 分类名称
     */
    private String classifyName;

    /**
     * 分类类型
     */
    private String classifyType;

    /**
     * 消防设施ID
     */
    private Long fireFacilityId;

    /**
     * 消防设施编码
     */
    private String fireFacilityCode;

    /**
     * 消防设施名称
     */
    private String fireFacilityName;

    /**
     * 消防设施类型
     */
    private String fireFacilityType;

    /**
     * 位置
     */
    private String location;


    /**
     * 建筑ID
     */
    private Long buildingId;

    /**
     * 建筑名称
     */
    private String buildingName;


    /**
     * 详情位置
     */
    private String area;



}
