package com.yeejoin.amos.patrol.business.dao.repository;

import java.io.Serializable;
import java.util.List;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;

/**
 * 基础dao
 * 
 * @param <T>
 * @param <ID>
 */
@NoRepositoryBean
public interface BaseDao<T, ID extends Serializable> extends JpaRepository<T, ID>, CrudRepository<T, ID>,
		PagingAndSortingRepository<T, ID>, JpaSpecificationExecutor<T> {

	public default T getOneBySpecification(Specification<T> specification) {
		List<T> list = findAll(specification);
		if (list.isEmpty()) {
			return null;
		} else {
			return list.get(0);
		}
	}

}
