package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.Elevator;
import com.yeejoin.amos.boot.module.tzs.api.mapper.ElevatorMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IElevatorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;

/**
*  服务实现类
*
* @author tb
* @date 2021-06-01
*/
@Service
public class ElevatorServiceImpl extends BaseService<ElevatorDto, Elevator, ElevatorMapper> implements IElevatorService {

    @Autowired
    SourceFileServiceImpl sourceFileService;

    @Autowired
    AlertCalledServiceImpl alertCalledServiceImpl;

    /**
     * 保存电梯信息
     *
     * @param elevatorDto
     * @return
     */
    public ElevatorDto saveElevator(ElevatorDto elevatorDto) {
        elevatorDto = createWithModel(elevatorDto);

        // 保存附件
        sourceFileService.saveAttachments(elevatorDto.getSequenceNbr(), elevatorDto.getAttachments());
        return elevatorDto;
    }

    /**
     * 批量删除电梯信息
     *
     * @param seqStr 电梯主键（逗号分割）
     * @return
     */
    public boolean deleteBatchBySeq(String seqStr) {
        if (!ValidationUtil.isEmpty(seqStr)) {
            List<String> seqList = Lists.newArrayList(seqStr.split(","));
            LambdaUpdateWrapper<Elevator> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
            lambdaUpdateWrapper.in(Elevator::getSequenceNbr, seqList).set(Elevator::getIsDelete, true);
            this.update(lambdaUpdateWrapper);
            return true;
        }
        return false;
    }

    /**
     * 更新电梯信息
     *
     * @param elevatorDto
     * @return
     */
    public ElevatorDto updateElevator(ElevatorDto elevatorDto) {
        elevatorDto = updateWithModel(elevatorDto);

        // 保存附件
        sourceFileService.saveAttachments(elevatorDto.getSequenceNbr(), elevatorDto.getAttachments());
        return elevatorDto;
    }

    /**
     * 根据id查询电梯信息
     *
     * @param sequenceNbr
     * @return
     */
    public ElevatorDto selectBySeq(Long sequenceNbr) {
        ElevatorDto elevatorDto = this.queryBySeq(sequenceNbr);

        // 获取附件
        elevatorDto.setAttachments(sourceFileService.getAttachments(sequenceNbr));
        return elevatorDto;
    }

    @Override
    public Elevator selectByAlertId(Long alertId) {
        AlertCalledDto alertCalledDto = alertCalledServiceImpl.queryBySeq(alertId);
        if (ValidationUtil.isEmpty(alertCalledDto)
                || ValidationUtil.isEmpty(alertCalledDto.getDeviceId()))
            throw new BadRequest("警情不存在或者设备编码不存在");
        // 设备类型 和 编码 确定设备的使用单位或者维保单位
        String equipmentClassificationCode = alertCalledDto.getEquipmentClassificationCode();
        String deviceId = alertCalledDto.getDeviceId();
        // 目前只有电梯类型
        LambdaQueryWrapper<Elevator> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(Elevator::getRescueCode, deviceId);
        Elevator elevator = this.getOne(queryWrapper);
        if (ValidationUtil.isEmpty(elevator))
            throw new BadRequest("设备未找到");
        return elevator;
    }
}
