package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 附件表
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_file")
@ApiModel(value="TmJgFile对象", description="附件表")
public class JgFile extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "附件名")
    private String fileName;

    @ApiModelProperty(value = "附件url地址")
    private String fileUrl;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "所属对象")
    private String objectType;

    @ApiModelProperty(value = "所属属性名 ")
    private String attributeType;

    @ApiModelProperty(value = "附件来源设备的squence_nbr（标识码）")
    private Long squNbr;

}
