package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 人员资质信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_qualifications")
@ApiModel(value = "PersonQualifications对象", description = "人员资质信息")
public class PersonQualifications extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "证件类别key")
    private String certificateTypeKey;
    @ApiModelProperty(value = "证件名称key")
    private String certificateNameKey;
    @ApiModelProperty(value = "取证项目")
    private String certificateProject;
    @ApiModelProperty(value = "发证机关")
    @TableField("Issuing_authority")
    private String issuingAuthority;
    @ApiModelProperty(value = "证书编号")
    private String certificateNumber;
    @ApiModelProperty(value = "取证时间")
    private Date certificateObtainTime;
    @ApiModelProperty(value = "有效期限（年）")
    private String expireDate;
    @ApiModelProperty(value = "证书等级")
    private String certificateLevel;
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<PersonQualificationsAttachment> attachment;
}
