package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.BuildingAudit;
import com.yeejoin.equipmanage.common.entity.FormInstance;
import com.yeejoin.equipmanage.common.entity.SourceFile;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.BuildingAuditVO;
import com.yeejoin.equipmanage.mapper.BuildingAuditMapper;
import com.yeejoin.equipmanage.service.IBuildingAuditService;
import com.yeejoin.equipmanage.service.IEqSourceFileService;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BuildingAuditServiceImpl extends ServiceImpl<BuildingAuditMapper, BuildingAudit> implements IBuildingAuditService {

    @Autowired
    private IEqSourceFileService iEqSourceFileService;

    @Autowired
    private BuildingAuditMapper buildingAuditMapper;

    @Autowired
    private IFormInstanceService iFormInstanceService;

    @Override
    public boolean saveAudit(BuildingAuditVO buildingAuditVO) {
        // 保存基础数据
        BuildingAudit buildingAudit = new BuildingAudit();
        BeanUtils.copyProperties(buildingAuditVO, buildingAudit);
        LambdaQueryWrapper<FormInstance> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(FormInstance::getInstanceId,buildingAuditVO.getBuildingId());
        queryWrapper.eq(FormInstance::getFieldName,"name");
        FormInstance formInstance = iFormInstanceService.getOne(queryWrapper);
        buildingAudit.setBuildingName(formInstance.getFieldValue());
        boolean flag = this.save(buildingAudit);
        // 保存文件路径名称
        long id = buildingAudit.getId();
        if (buildingAuditVO.getAuditFile() != null) {
            iEqSourceFileService.saveSourceFile(id, buildingAuditVO.getAuditFile());
        }
        return flag;
    }

    @Override
    public IPage<BuildingAudit> auditList(Page page, BuildingAuditVO buildingAuditVO) {
        LambdaQueryWrapper<BuildingAudit> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BuildingAudit::getIsDelete, false);
        if (StringUtil.isNotEmpty(buildingAuditVO.getBuildingId())){
            queryWrapper.eq(BuildingAudit::getBuildingId,buildingAuditVO.getBuildingId());
        }
        if (StringUtil.isNotEmpty(buildingAuditVO.getAuditTypeId())) {
            queryWrapper.eq(BuildingAudit::getAuditTypeId,buildingAuditVO.getAuditTypeId());
        }
        if (StringUtil.isNotEmpty(buildingAuditVO.getAuditUnit())) {
            queryWrapper.like(BuildingAudit::getAuditUnit,buildingAuditVO.getAuditUnit());
        }
        if (StringUtil.isNotEmpty(buildingAuditVO.getStartTime())) {
            queryWrapper.ge(BuildingAudit::getAuditTime,buildingAuditVO.getStartTime());
        }
        if (StringUtil.isNotEmpty(buildingAuditVO.getEndTime())) {
            queryWrapper.le(BuildingAudit::getAuditTime,buildingAuditVO.getEndTime());
        }
        IPage pageArea = this.baseMapper.selectPage(page,queryWrapper);
        return pageArea;
    }

    @Override
    public int deleteAudit(List<Long> ids) {
       return buildingAuditMapper.deleteAd(ids);
    }

    @Override
    public BuildingAuditVO getAuditById(Long id) {
        BuildingAuditVO buildingAuditVO = new BuildingAuditVO();
        BuildingAudit buildingAudit = this.baseMapper.selectById(id);
        BeanUtils.copyProperties(buildingAudit, buildingAuditVO);
        Long sourceId = buildingAudit.getId();
        buildingAuditVO.setAuditFile(iEqSourceFileService.findBySourceId(sourceId));
        return buildingAuditVO;
    }

    @Override
    public int editAudit(BuildingAuditVO buildingAuditVO) {
        Long id = buildingAuditVO.getId();
        BuildingAudit buildingAudit = new BuildingAudit();
        BeanUtils.copyProperties(buildingAuditVO,buildingAudit);
        int flag = this.baseMapper.updateById(buildingAudit);
        List<SourceFile> list = buildingAuditVO.getAuditFile();
        // 保存图片
        if (list != null) {
            iEqSourceFileService.saveSourceFile(id, list);
        }
        return flag;
    }
}
