package com.yeejoin.equipmanage.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author keyong
 * @title: ClassToJsonUtil
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/4/11 11:28
 */
public class ClassToJsonUtil {

    private static Map<String, Object> map = new HashMap<>();

    public static String class2json(Object obj, Resource commonMessage, String topic) {
        String json;
        try {
            json = IOUtils.toString(commonMessage.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            throw new RuntimeException("获取kafka信息模板失败！");
        }
        List<Map> listModel = JSONObject.parseArray(json, Map.class);
        if (0 < listModel.size()) {
            List<Map> mapList = listModel.stream().filter(x -> String.valueOf(x.get("kafkaTopic")).equalsIgnoreCase(topic)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(mapList)) {
                Map<String, Object> map1 = mapList.get(0);
                JSONObject object = JSON.parseObject(String.valueOf(obj));
                analysisJson(object, "");
                JSONObject res = analyseJson(JSON.toJSONString(map1), map);
                res.put("kafkaTopic", map1.get("kafkaTopic"));
                res.put("mqTopic", map1.get("mqTopic"));
                return JSON.toJSONString(res);
            }
        }
        return null;
    }


    private static JSONObject analysisJson(Object objJson, String flag) {
        if (objJson instanceof JSONArray) {//如果obj为json数组
            JSONArray objArray = (JSONArray) objJson;
            for (int i = 0; i < objArray.size(); i++) {
                analysisJson(objArray.get(i), flag);
            }
        } else if (objJson instanceof JSONObject) {//如果为json对象
            JSONObject jsonObject = (JSONObject) objJson;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get(key);
                //如果得到的是数组
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray) object;
                    String path = "";
                    if (StringUtils.isNotBlank(flag)) {
                        path = flag + "." + key;
                    } else {
                        path = key;
                    }
                    analysisJson(objArray, path);
                } else if (object instanceof JSONObject) {//如果key中是一个json对象
                    String path = "";
                    if (StringUtils.isNotBlank(flag)) {
                        path = flag + "." + key;
                    } else {
                        path = key;
                    }
                    analysisJson((JSONObject) object, path);
                } else {//如果key中是其他
                    String path = "";
                    if (StringUtils.isNotBlank(flag)) {
                        path = flag + "." + key;
                    } else {
                        path = key;
                    }
//                    System.out.println(path+":"+object.toString()+" ");
                    map.put(path, String.valueOf(object));
                }
            }
        } else {//如果key中是其他
//            System.out.println(flag+":"+objJson.toString()+" ");
            map.put(flag, String.valueOf(objJson));
        }
        return JSONObject.parseObject(JSON.toJSONString(map));
    }

    public static JSONObject analyseJson(String jsonData, Map<String, Object> keyMap) {
        SortedMap<String, Object> map = new TreeMap<>();
        JSONObject jsonObject = JSON.parseObject(jsonData);
        for (String key : jsonObject.keySet()) {
            String resKey = keyMap.get(key) == null ? key : String.valueOf(keyMap.get(key));
            Object value = jsonObject.get(key);
            if (value instanceof JSONArray) {
                JSONArray jsonArray = new JSONArray(new LinkedList<>());
                JSONArray array = jsonObject.getJSONArray(key);
                for (int i = 0; i < array.size(); i++) {
                    Object object = array.get(i);
                    if (object instanceof String) {
                        map.put(resKey, array);
                    } else {
                        JSONObject sortJson = analyseJson(String.valueOf(object), keyMap);
                        jsonArray.add(sortJson);
                        map.put(resKey, jsonArray);
                    }
                }
            } else if (value instanceof JSONObject) {
                JSONObject sortJson = analyseJson(String.valueOf(value), keyMap);
                map.put(resKey, sortJson);
            } else {
                map.put(resKey, ObjectUtils.isNotEmpty(keyMap.get(value)) ? keyMap.get(value) : "");
            }
        }
        return new JSONObject(map);
    }

}
