package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireAlarmDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireAlarmDayStatistics;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireAlarmDayStatisticsMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireAlarmDayStatisticsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 换流站告警日统计服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireAlarmDayStatisticsServiceImpl extends BaseService<FireAlarmDayStatisticsDto, FireAlarmDayStatistics, FireAlarmDayStatisticsMapper> implements IFireAlarmDayStatisticsService {

    /**
     * 列表查询 示例
     */
    public List<FireAlarmDayStatisticsDto> queryForFireAlarmDayStatisticsList() {
        return this.queryForList("", false);
    }

    public int alarmTimesCount(String stationCode, String beginDate, String endDate) {
        LambdaQueryWrapper<FireAlarmDayStatistics> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(StringUtils.isNotBlank(stationCode), FireAlarmDayStatistics::getStationCode, stationCode);
        wrapper.ge(FireAlarmDayStatistics::getCollectDate, beginDate);
        wrapper.le(FireAlarmDayStatistics::getCollectDate, endDate);
        List<FireAlarmDayStatistics> list = this.list(wrapper);
        return list.stream().mapToInt(FireAlarmDayStatistics::getAlarmTimes).sum();
    }

    public List<String> alarmTimesTrend(String stationCode, String beginDate, String endDate) {
        return this.baseMapper.queryAlarmTimesTrend(stationCode, beginDate, endDate);
    }
}