package com.yeejoin.amos.boot.module.tcm.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.tcm.flc.api.entity.RegUnitInfo;
import com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl.RegUnitInfoServiceImpl;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@RequiredArgsConstructor
public class HisDataHandlerServiceImpl {

    private final TzBaseEnterpriseInfoServiceImpl tzBaseEnterpriseInfoService;

    private final TzsUserInfoServiceImpl userInfoService;

    private final RegUnitInfoServiceImpl regUnitInfoService;

    private final String UNIT_TYPE_JYJG = "检验机构";

    private final String UNIT_TYPE_JCJG = "检测机构";

    /**
     * 检测机构-用户组
     */
    @Value("${jcjg.permission.group.id:1945047210483806209}")
    private Long jcjgGroupId;

    /**
     * 检验机构-用户组
     */
    @Value("${jyjg.permission.group.id:1945047035287728129}")
    private Long jyjgGroupId;


    /**
     * 检验机构业务办理人员-用户组
     */
    @Value("${jyywy.permission.group.id:1947231335688990722}")
    private Long jyywyGroupId;

    /**
     * 检测机构业务办理人员-用户组
     */
    @Value("${jcywy.permission.group.id:1947231362847109122}")
    private Long jcywyGroupId;

    /**
     * 将检验或者检测机构的管理员增加到对应的用户组
     *
     * @return 处理的条数
     */
    public Long addAdminUser2JyjcGroup() {
        List<String> jyjgUserIds = new ArrayList<>();
        List<String> jcjgUserIds = new ArrayList<>();
        List<RegUnitInfo> unitInfoDtos = regUnitInfoService.getBaseMapper().selectAdminUserOfJyjc();
        unitInfoDtos.forEach(unitInfoDto -> {
            if (unitInfoDto.getUnitType().contains(UNIT_TYPE_JYJG)) {
                jyjgUserIds.add(unitInfoDto.getAdminUserId());
            }
            if (unitInfoDto.getUnitType().contains(UNIT_TYPE_JCJG)) {
                jcjgUserIds.add(unitInfoDto.getAdminUserId());
            }
        });
        if (!jyjgUserIds.isEmpty()) {
            Privilege.groupUserClient.create(jyjgGroupId, jyjgUserIds);
        }
        if (!jcjgUserIds.isEmpty()) {
            Privilege.groupUserClient.create(jcjgGroupId, jcjgUserIds);
        }
        return (long) (jyjgUserIds.size() + jcjgUserIds.size());
    }

    /**
     * 将已经创建平台账号的检验或者检测业务办理人员增加到对应的用户组
     *
     * @return 处理的条数
     */
    public Long addBizUser2NewBizGroup() {
        List<String> jyywyUserIds = new ArrayList<>();
        List<String> jcywyUserIds = new ArrayList<>();
        List<TzsUserInfoDto> userInfoDtos = userInfoService.getBaseMapper().select6616User();
        userInfoDtos.forEach(userInfoDto -> {
            if (userInfoDto.getUnitType().contains(UNIT_TYPE_JYJG)) {
                jyywyUserIds.add(userInfoDto.getAmosUserId());
            }
            if (userInfoDto.getUnitType().contains(UNIT_TYPE_JCJG)) {
                jcywyUserIds.add(userInfoDto.getAmosUserId());
            }
        });
        if (!jyywyUserIds.isEmpty()) {
            Privilege.groupUserClient.create(jyywyGroupId, jyywyUserIds);
        }
        if (!jcywyUserIds.isEmpty()) {
            Privilege.groupUserClient.create(jcywyGroupId, jcywyUserIds);
        }
        return (long) (jyywyUserIds.size() + jcywyUserIds.size());
    }

    public Long companyTypeUpdate() {
        List<TzBaseEnterpriseInfo> enterpriseInfos = tzBaseEnterpriseInfoService.list(new LambdaQueryWrapper<TzBaseEnterpriseInfo>()
                .eq(BaseEntity::getIsDelete, false)
                .and(e -> e
                        .like(TzBaseEnterpriseInfo::getUnitType, UNIT_TYPE_JYJG).or()
                        .like(TzBaseEnterpriseInfo::getUnitType, UNIT_TYPE_JCJG))
                .select(BaseEntity::getSequenceNbr, TzBaseEnterpriseInfo::getUseCode, TzBaseEnterpriseInfo::getUnitType));
        enterpriseInfos.forEach(enterpriseInfo -> {
            // 业务多个单位类型按照# 隔开， 平台已， 隔开
            String unitType = enterpriseInfo.getUnitType().replace("#", ",");
            CompanyModel companyModel = Privilege.companyClient.queryByCompanyCode(enterpriseInfo.getUseCode()).getResult();
            // 平台更新时 业务有公司 平台无公司时会报错所以进行判断
            if (companyModel != null) {
                Privilege.companyClient.updateCompanyType(enterpriseInfo.getUseCode(), unitType);
            }
        });
        return (long) enterpriseInfos.size();
    }
}
