package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 装备分类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "装备分类Api")
@RequestMapping(value = "/common")
public class CommonController extends BaseController {
	@Autowired
	ICommonService commonService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getChildren")
	@ApiOperation(httpMethod = "GET", value = "通过设备种类code获取设备类别", notes = "通过设备种类code获取设备类别")
	public ResponseModel<List<EquipmentCategory>> getChildren(@RequestParam(value = "code") String code,
															  @RequestParam(value = "type", required = false) String type) {
		return ResponseHelper.buildResponse(commonService.getEquipmentCategoryList(code, type));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getRegion")
	@ApiOperation(httpMethod = "GET", value = "获取行政区划", notes = "获取行政区划")
	public ResponseModel<Object> getRegion(@RequestParam(value = "level", required = false) String level,
										   @RequestParam(value = "parentId", required = false) String parentId) {
		return ResponseHelper.buildResponse(commonService.getRegion(level, parentId));
	}

	/**
	 * 获取管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/creatTree")
	@ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
	public ResponseModel<Object> creatTree() {
		return ResponseHelper.buildResponse(commonService.getTree(getSelectedOrgInfo()));
	}


	/**
	 * 获取行政审批局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getApproveTree")
	@ApiOperation(httpMethod = "GET", value = "获取行政审批局树", notes = "获取行政审批局树")
	public ResponseModel<Object> getApproveTree() {
		ReginParams reginParams = getSelectedOrgInfo();
		return ResponseHelper.buildResponse(commonService.getApproveTree(reginParams));
	}

	/**
	 * 通过单位类型获取单位列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUnitList")
	@ApiOperation(httpMethod = "GET", value = "通过单位类型获取单位列表", notes = "通过单位类型获取单位列表")
	public ResponseModel<List<Map<String,Object>>> getUnitList(@RequestParam(value = "type") String type) {
		return ResponseHelper.buildResponse(commonService.getUnitListByType(type));
	}

	/**
	 * 查找当前公司下所属的安全管理员
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getSecurityAdmin")
	@ApiOperation(httpMethod = "GET", value = "查找当前公司下所属的安全管理员", notes = "查找当前公司下所属的安全管理员")
	public ResponseModel<List<Map<String, Object>>> getSecurityAdmin(@RequestParam(value = "type") String type,
																	@RequestParam(value = "useUnitCode",required = false)String useUnitCode) {
		return ResponseHelper.buildResponse(commonService.getSecurityAdmin(type,useUnitCode));
	}


	/**
	 * 查询安全管理员的基本信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUserPhone")
	@ApiOperation(httpMethod = "GET", value = "查询用户对应联系方式", notes = "查询用户对应联系方式")
	public ResponseModel<Map<String,Object>> getUserInfo(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(commonService.getUserInfo(sequenceNbr));
	}
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserInfoSplit")
    @ApiOperation(httpMethod = "GET", value = "查询安全管理员的基本信息", notes = "查询安全管理员的基本信息")
    public ResponseModel<Map<String, Object>> getUserInfoSplit(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        if (sequenceNbr.contains("_")) {
            sequenceNbr = sequenceNbr.split("_")[0];
        }
        return ResponseHelper.buildResponse(commonService.getUserInfo(sequenceNbr));
    }
	/**
	 * 查询企业的基本信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEnterpriseInfo")
	@ApiOperation(httpMethod = "GET", value = "查询企业的基本信息", notes = "查询企业的基本信息")
	public ResponseModel<Map<String,Object>> getEnterpriseInfo(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(commonService.getEnterpriseInfo(sequenceNbr));
	}

	/**
	 * 查询企业的下面的人员
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEnterpriseEmployee")
	@ApiOperation(httpMethod = "GET", value = "查询企业的下面的人员", notes = "查询企业的下面的人员")
	public ResponseModel<List<Map<String,Object>>> getEnterpriseEmployee(@RequestParam String unitCode) {
		String companyCode = unitCode.split("_")[0];
		return ResponseHelper.buildResponse(commonService.getEnterpriseEmployee(companyCode));
	}

	@TycloudOperation (ApiLevel = UserType.AGENCY)
	@ApiOperation (httpMethod = "GET", value = "流程状态枚举列表", notes = "流程状态枚举列表")
	@GetMapping (value = "/flow-status/list")
	public ResponseModel<List<Map<String, Object>>> selectForFlowStatusList() {
		return ResponseHelper.buildResponse(Arrays.stream(FlowStatusEnum.values()).map(this::mapPointTypeToMap).filter(Objects::nonNull).collect(Collectors.toList()));
	}

	private Map<String, Object> mapPointTypeToMap(FlowStatusEnum e) {
		if (FlowStatusEnum.TO_SUBMITTED.getCode() ==  e.getCode() || FlowStatusEnum.TO_BE_DISCARD.getCode() == e.getCode()) {
			return null;
		}
		Map<String, Object> record = new HashMap<>();
		record.put("key", e.getCode());
		record.put("label", e.getName());
		return record;
	}

	/**
	 * 查询监管业务名称列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询监管业务名称列表", notes = "查询监管业务名称列表")
	@GetMapping(value = "/superviseBusinessCategory")
	public ResponseModel<Object> equipTree(String type) {
		return ResponseHelper.buildResponse(commonService.superviseBusinessCategory(type));
	}


	@Autowired
	private IJgInstallationNoticeService iJgInstallationNoticeService;


	/**
	 * 业务发起公共接口
	 * /jg/jg-installation-notice/save
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrSubmit")
	@ApiOperation(httpMethod = "POST", value = "业务发起公共接口", notes = "业务发起公共接口")
	public ResponseModel<Object> save(@RequestParam(value = "submitType", required = false) String submitType,
									  @RequestBody Map<String, Object> map) {
		ReginParams reginParams = getSelectedOrgInfo();
		Object result = commonService.invokeBusinessProcess(submitType, map, reginParams);
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据公司id获取公司下人员
	 *
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCompanyUser")
	@ApiOperation(httpMethod = "get", value = "根据公司id获取公司下人员", notes = "根据公司id获取公司下人员")
	public ResponseModel<Object> getCompanyUser(@RequestParam(value = "companyId",required = false) Long companyId) {
		if(ObjectUtils.isEmpty(companyId)){
			return null;
		}
		Object result = commonService.getCompanyUser(companyId);
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 获取当前登录人企业类型
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCompanyType")
	@ApiOperation(httpMethod = "GET", value = "获取当前登录人企业类型", notes = "获取当前登录人企业类型")
	public ResponseModel<Object> getCompanyType() {
		return ResponseHelper.buildResponse(iJgInstallationNoticeService.getCompanyType());
	}
	/**
	 * 获取管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCreatTree")
	@ApiOperation(httpMethod = "GET", value = "获取管辖分局树", notes = "获取管辖分局树")
	public ResponseModel<Object> getCreatTree() {
		return ResponseHelper.buildResponse(commonService.getCreatTree());
	}


	/**
	 * 获取管辖分局树
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCreatTreeByInstallation")
	@ApiOperation(httpMethod = "GET", value = "获取管辖分局树安装告知使用", notes = "获取管辖分局树安装告知使用")
	public ResponseModel<Object> getCreatTreeByInstallation(String county) {
		List<LinkedHashMap> creatTree = commonService.getCreatTreeByInstallation();
		String code = county.split("_")[0];
		List<LinkedHashMap> infoByCounty = getInfoByCounty(code, creatTree);
		return ResponseHelper.buildResponse(infoByCounty);
	}

	private List<LinkedHashMap> getInfoByCounty(String county, List<LinkedHashMap> children) {
		for (LinkedHashMap item : children) {
			if (item.get("level").toString().equals("county") && item.get("companyCode").toString().equals(county)) {
				return (List<LinkedHashMap>) item.get("children");
			} else {
				if (!ObjectUtils.isEmpty(item.get("children"))) {
					List<LinkedHashMap> children1 = getInfoByCounty(county, (List<LinkedHashMap>) item.get("children"));
					if (!CollectionUtils.isEmpty(children1)) {
						return children1;
					}
				}
			}
		}
		return new ArrayList<>();
	}


	/**
	 * 公共转办接口
	 * /jg/common/transfer
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/transfer")
	@ApiOperation(httpMethod = "POST", value = "公共转办接口", notes = "公共转办接口")
	public ResponseModel<Object> transfer(@RequestBody Map<String, Object> map) {
		Object result = commonService.transfer(map);
		return ResponseHelper.buildResponse(result);
	}


}
