package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.netflix.ribbon.proxy.annotation.Http;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationTransferService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;

import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationTransferDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 移装变更登记登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "移装变更登记登记Api")
@RequestMapping(value = "/jg-change-registration-transfer")
public class JgChangeRegistrationTransferController extends BaseController {
	private static final String TABLE_PAGE_ID = "changeRegistrationTransfer";
	
    @Autowired
	IJgChangeRegistrationTransferService jgChangeRegistrationTransferService;
	@Autowired
	IJgInstallationNoticeService iJgInstallationNoticeService;

    /**
     * 新增移装变更登记登记
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增移装变更登记登记", notes = "新增移装变更登记登记")
	public ResponseModel<Object> save(@RequestParam(value = "submitType") String submitType,
									   @RequestBody JSONObject map) {
		Map<String, Object> tableData = (Map<String, Object>) map.get(TABLE_PAGE_ID);
		if(ValidationUtil.isEmpty(tableData)){
			throw new BadRequest("参数校验失败.");
		}
		String equId = (String) tableData.get("record");
		if(ValidationUtil.isEmpty(equId)){
			throw new BadRequest("参数校验失败.");
		}
		ReginParams reginParams = getSelectedOrgInfo();
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferService.createTransfer(submitType, map, reginParams));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param submitType
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/update")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新移装变更登记登记", notes = "根据sequenceNbr更新移装变更登记登记")
	public ResponseModel<Object> updateBySequenceNbr(@RequestParam(value = "submitType") String submitType,
													 @RequestBody JSONObject map) {
		Map<String, Object> tableData = (Map<String, Object>) map.get(TABLE_PAGE_ID);
		if(ValidationUtil.isEmpty(tableData)){
			throw new BadRequest("参数校验失败.");
		}
		String equId = (String) tableData.get("sequenceNbr");
		if(ValidationUtil.isEmpty(equId)){
			throw new BadRequest("参数校验失败.");
		}
		ReginParams reginParams = getSelectedOrgInfo();
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferService.updateTransfer(submitType, map, reginParams));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/flowExecute")
	@ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
	public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
		jgChangeRegistrationTransferService.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),String.valueOf(map.get("instanceId")), String.valueOf(map.get("operate")), String.valueOf(map.get("opinion")));
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/revocation")
	@ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
	public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
		jgChangeRegistrationTransferService.revocation(String.valueOf(map.get("instanceId")));
		return ResponseHelper.buildResponse("ok");
	}

	/**
	 * 根据sequenceNbrs批量删除
	 *
	 * @param sequenceNbrs 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/deteteBatch")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除移装变更登记登记", notes = "根据sequenceNbr删除移装变更登记登记")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "sequenceNbrs") Long[] sequenceNbrs){
		return ResponseHelper.buildResponse(jgChangeRegistrationTransferService.deleteBatchBySequenceNbrs(sequenceNbrs));
	}

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个移装变更登记登记",  notes = "根据sequenceNbr查询单个移装变更登记登记")
	public ResponseModel<Map<String, Map<String, Object>>> selectOne(@RequestParam(value = "sequenceNbr") String sequenceNbr,
																	 @RequestParam(value = "equipId", required = false) String equipId) {
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferService.getTransferDetail(sequenceNbr, equipId));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "移装变更登记登记分页查询",  notes = "移装变更登记登记分页查询")
	public ResponseModel<Page<Map<String, Object>>> queryForPage(@RequestParam(value = "current") int current,
																			 @RequestParam(value = "size") int size,
																			 JgChangeRegistrationTransferDto params) {
		Page<Map<String, Object>> page = new Page<>(current, size);
		String type = (String) iJgInstallationNoticeService.getCompanyType().get("companyLevel");
		return ResponseHelper.buildResponse(jgChangeRegistrationTransferService.queryListForPage(page,params, type));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "导出使用登记证", notes = "导出使用登记证")
	public void exportImageZip(HttpServletResponse response, @RequestParam("sequenceNbr") String sequenceNbr){
		jgChangeRegistrationTransferService.exportUseRegistrationCertificate(sequenceNbr, response);
	}

}
