package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-use-registration")
public class JgUseRegistrationController extends BaseController {

    @Autowired
    JgUseRegistrationServiceImpl jgUseRegistrationServiceImpl;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<Object> save(@RequestBody JSONObject map) {
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.save(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgUseRegistrationServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),String.valueOf(map.get("instanceId")), String.valueOf(map.get("operate")), String.valueOf(map.get("comment")));
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/withdraw")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    public ResponseModel<Object> withdraw(@RequestBody JSONObject map) {
        jgUseRegistrationServiceImpl.withdraw(String.valueOf(map.get("instanceId")));
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        jgUseRegistrationServiceImpl.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "删除", notes = "删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        ArrayList<Long> ids = new ArrayList<>();
        ids.add(id);
        jgUseRegistrationServiceImpl.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getList")
    public ResponseModel<Page<Map<String, Object>>> getList(JgUseRegistrationDto dto,
                                                            @RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        ReginParams info = getSelectedOrgInfo();
        dto.setCurrentUserId(info.getUserModel().getUserId());
        if (info.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)){
            dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
        }else {
            dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
        }
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getList(dto, page,  dto.getRoleIds()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getEquipList")
    public ResponseModel<Page<Map<String, Object>>> getEquipList(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "factoryNum", required = false) String factoryNum,
            @RequestParam(value = "equList", required = false) String equList,
            @RequestParam(value = "equCategory", required = false) String equCategory) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getEquipList(page, factoryNum, equList, equCategory));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "详情", notes = "详情")
    @GetMapping(value = "/getDetail")
    public ResponseModel<Map<String, Object>> getDetail(@RequestParam("record") String record, @RequestParam(value = "sequenceNbr", required = false) Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getDetail(record, sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getMessage")
    public ResponseModel<Map<String, Object>> getMessage() {
        ReginParams selectedOrgInfo = getSelectedOrgInfo();
        HashMap<String, Object> map = new HashMap<>();
        map.put("useUnitCreditCode", selectedOrgInfo.getCompany().getCompanyCode());
        map.put("useUnitName", selectedOrgInfo.getCompany().getCompanyName());
        return ResponseHelper.buildResponse(map);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询当前登录人角色", notes = "查询当前登录人角色")
    @GetMapping(value = "/getRole")
    public ResponseModel<Object> getRole() {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
        List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
        String roleIds = String.join(",", userOrgRoleList);
        map.put("roleIds", roleIds);
        return ResponseHelper.buildResponse(map);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/export")
    @ApiOperation(httpMethod = "GET", value = "导出使用登记证", notes = "导出使用登记证")
    public void exportImageZip(HttpServletResponse response, @RequestParam("sequenceNbr") String sequenceNbr){
        jgUseRegistrationServiceImpl.exportUseRegistrationCertificate(sequenceNbr, response);
    }

}
