package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-场内车辆
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgTechParamsVehicleDto", description="安全追溯-场内车辆")
public class IdxBizJgTechParamsVehicleDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "车架编号")
    @TableField("FRAME_NO")
    private String frameNo;

    @ApiModelProperty(value = "发动机（行走电机）编号")
    @TableField("ENGINE_NO")
    private String engineNo;

    @ApiModelProperty(value = "动力方式")
    @TableField("POWER_MODE")
    private String powerMode;

    @ApiModelProperty(value = "传动方式")
    @TableField("TRANSMISSION_MODE")
    private String transmissionMode;

    @ApiModelProperty(value = "车架结构")
    @TableField("FRAME_STRUCTURE")
    private String frameStructure;

    @ApiModelProperty(value = "驾驶方式")
    @TableField("DRIVING_MODE")
    private String drivingMode;

    @ApiModelProperty(value = "自重")
    @TableField("WEIGHT")
    private String weight;

    @ApiModelProperty(value = "空载最大运行速度")
    @TableField("CARRYING_IDLER_MAX_RUNNING_SPEED")
    private String carryingIdlerMaxRunningSpeed;

    @ApiModelProperty(value = "空载最大起升速度")
    @TableField("MAX_LIFTING_SPEED")
    private String maxLiftingSpeed;

    @ApiModelProperty(value = "设备保护等级（防爆）")
    @TableField("PROTECT_GRADE")
    private String protectGrade;

    @ApiModelProperty(value = "气体/粉尘组别（防爆）")
    @TableField("GAS_GROUP")
    private String gasGroup;

    @ApiModelProperty(value = "温度组别（防爆）")
    @TableField("TEMPERATURE_GROUP")
    private String temperatureGroup;

    @ApiModelProperty(value = "额定起重量")
    @TableField("LIFTING_CAPACITY")
    private String liftingCapacity;

    @ApiModelProperty(value = "系统电压")
    @TableField("SYSTEM_VOLTAGE")
    private String systemVoltage;

    @ApiModelProperty(value = "载荷中心距")
    @TableField("LOAD_CENTER_DISTANCE")
    private String loadCenterDistance;

    @ApiModelProperty(value = "发动机(电机)额定功率")
    @TableField("ENGINE_POWER")
    private String enginePower;

    @ApiModelProperty(value = "最大速度（额载）")
    @TableField("MAX_SPEED")
    private String maxSpeed;

    @ApiModelProperty(value = "防爆使用场所")
    @TableField("EXPLOSIONPROOF_PLACE")
    private String explosionproofPlace;

    @ApiModelProperty(value = "工作装置门架形式")
    @TableField("GANTRY_FORM")
    private String gantryForm;

    @ApiModelProperty(value = "工作装置空载最大起升高度")
    @TableField("MAX_LIFTING_HEIGHT")
    private String maxLiftingHeight;

    @ApiModelProperty(value = "工作装置(全)自由起升高度")
    @TableField("FREE_LIFTING_HEIGHT")
    private String freeLiftingHeight;

    @ApiModelProperty(value = "工作装置门架倾角（前）")
    @TableField("PORTAL_ANGLE_FRONT")
    private String portalAngleFront;

    @ApiModelProperty(value = "工作装置门架倾角（后）")
    @TableField("PORTAL_ANGLE_BEHIND")
    private String portalAngleBehind;

    @ApiModelProperty(value = "工作装置最大起升速度（空载）")
    @TableField("MAX_LIFTING_SPEED1")
    private String maxLiftingSpeed1;

    @ApiModelProperty(value = "工作装置最大起升速度（额载）")
    @TableField("MAX_LIFTING_SPEED2")
    private String maxLiftingSpeed2;

    @ApiModelProperty(value = "工作装置最大下降速度（空载）")
    @TableField("MAX_DESCENT_SPEED1")
    private String maxDescentSpeed1;

    @ApiModelProperty(value = "工作装置最大下降速度（额载）")
    @TableField("MAX_DESCENT_SPEED2")
    private String maxDescentSpeed2;

    @ApiModelProperty(value = "整车整备质量")
    @TableField("VEHICLE_MASS")
    private String vehicleMass;

    @ApiModelProperty(value = "额定载客数")
    @TableField("PASSENGERS_NUMBER")
    private Integer passengersNumber;

    @ApiModelProperty(value = "最大运行速度")
    @TableField("MAX_RUNNING_SPEED")
    private String maxRunningSpeed;

    @ApiModelProperty(value = "轴距")
    @TableField("WHEEL_BASE")
    private String wheelBase;

    @ApiModelProperty(value = "轮距（前）")
    @TableField("TRACK_WIDTH_FRONT")
    private String trackWidthFront;

    @ApiModelProperty(value = "轮距（后）")
    @TableField("TRACK_WIDTH_BEHIND")
    private String trackWidthBehind;

    @ApiModelProperty(value = "观光列车车厢数")
    @TableField("CARS_NUMBER")
    private Integer carsNumber;

    @ApiModelProperty(value = "观光列车每节车厢座位数")
    @TableField("SEAT_NUMBER")
    private Integer seatNumber;

    @ApiModelProperty(value = "观光列车牵引车头座位数")
    @TableField("TRACTOR_SEAT_NUMBER")
    private Integer tractorSeatNumber;

    @ApiModelProperty(value = "最大行驶坡度")
    @TableField("MAX_DRIVING_SLOPE")
    private String maxDrivingSlope;

    @ApiModelProperty(value = "制动距离")
    @TableField("BRAKING_DISTANCE")
    private String brakingDistance;

    @ApiModelProperty(value = "全长")
    @TableField("OVERALL_LENGTH")
    private String overallLength;

    @ApiModelProperty(value = "全宽")
    @TableField("OVERALL_WIDTH")
    private String overallWidth;

    @ApiModelProperty(value = "全高")
    @TableField("OVERALL_ALTITUDE")
    private String overallAltitude;

    @ApiModelProperty(value = "最小离地间隙")
    @TableField("MIN_GROUND_CLEARANCE")
    private String minGroundClearance;

    @ApiModelProperty(value = "最小外侧转弯半径")
    @TableField("MIN_TURNING_RADIUS")
    private String minTurningRadius;

    @ApiModelProperty(value = "主要零部件、安全保护和防护装置")
    @TableField("MAIN_PARTS")
    private String mainParts;

}
